package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Release}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRelease.builder()}.
 */
@Generated(from = "StencilClient.Release", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRelease implements StencilClient.Release {
  private final String parentCommit;
  private final String name;
  private final String note;

  private ImmutableRelease(String parentCommit, String name, String note) {
    this.parentCommit = parentCommit;
    this.name = name;
    this.note = note;
  }

  /**
   * @return The value of the {@code parentCommit} attribute
   */
  @JsonProperty("parentCommit")
  @Override
  public String getParentCommit() {
    return parentCommit;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @JsonProperty("note")
  @Override
  public String getNote() {
    return note;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getParentCommit() parentCommit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentCommit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withParentCommit(String value) {
    String newValue = Objects.requireNonNull(value, "parentCommit");
    if (this.parentCommit.equals(newValue)) return this;
    return new ImmutableRelease(newValue, this.name, this.note);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRelease(this.parentCommit, newValue, this.note);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Release#getNote() note} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for note
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRelease withNote(String value) {
    String newValue = Objects.requireNonNull(value, "note");
    if (this.note.equals(newValue)) return this;
    return new ImmutableRelease(this.parentCommit, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRelease} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRelease
        && equalTo((ImmutableRelease) another);
  }

  private boolean equalTo(ImmutableRelease another) {
    return parentCommit.equals(another.parentCommit)
        && name.equals(another.name)
        && note.equals(another.note);
  }

  /**
   * Computes a hash code from attributes: {@code parentCommit}, {@code name}, {@code note}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + parentCommit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + note.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Release} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Release")
        .omitNullValues()
        .add("parentCommit", parentCommit)
        .add("name", name)
        .add("note", note)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Release", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Release {
    @Nullable String parentCommit;
    @Nullable String name;
    @Nullable String note;
    @JsonProperty("parentCommit")
    public void setParentCommit(String parentCommit) {
      this.parentCommit = parentCommit;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("note")
    public void setNote(String note) {
      this.note = note;
    }
    @Override
    public String getParentCommit() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getNote() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRelease fromJson(Json json) {
    ImmutableRelease.Builder builder = ImmutableRelease.builder();
    if (json.parentCommit != null) {
      builder.parentCommit(json.parentCommit);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.note != null) {
      builder.note(json.note);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Release} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Release instance
   */
  public static ImmutableRelease copyOf(StencilClient.Release instance) {
    if (instance instanceof ImmutableRelease) {
      return (ImmutableRelease) instance;
    }
    return ImmutableRelease.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRelease ImmutableRelease}.
   * <pre>
   * ImmutableRelease.builder()
   *    .parentCommit(String) // required {@link StencilClient.Release#getParentCommit() parentCommit}
   *    .name(String) // required {@link StencilClient.Release#getName() name}
   *    .note(String) // required {@link StencilClient.Release#getNote() note}
   *    .build();
   * </pre>
   * @return A new ImmutableRelease builder
   */
  public static ImmutableRelease.Builder builder() {
    return new ImmutableRelease.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRelease ImmutableRelease}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Release", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PARENT_COMMIT = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_NOTE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String parentCommit;
    private @Nullable String name;
    private @Nullable String note;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Release} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Release instance) {
      Objects.requireNonNull(instance, "instance");
      parentCommit(instance.getParentCommit());
      name(instance.getName());
      note(instance.getNote());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getParentCommit() parentCommit} attribute.
     * @param parentCommit The value for parentCommit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentCommit")
    public final Builder parentCommit(String parentCommit) {
      this.parentCommit = Objects.requireNonNull(parentCommit, "parentCommit");
      initBits &= ~INIT_BIT_PARENT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Release#getNote() note} attribute.
     * @param note The value for note 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("note")
    public final Builder note(String note) {
      this.note = Objects.requireNonNull(note, "note");
      initBits &= ~INIT_BIT_NOTE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRelease ImmutableRelease}.
     * @return An immutable instance of Release
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRelease build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRelease(parentCommit, name, note);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PARENT_COMMIT) != 0) attributes.add("parentCommit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_NOTE) != 0) attributes.add("note");
      return "Cannot build Release, some of required attributes are not set " + attributes;
    }
  }
}
