package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Link}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLink.builder()}.
 */
@Generated(from = "StencilClient.Link", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLink implements StencilClient.Link {
  private final ImmutableList<String> articles;
  private final String locale;
  private final String content;
  private final String contentType;
  private final String description;

  private ImmutableLink(
      ImmutableList<String> articles,
      String locale,
      String content,
      String contentType,
      String description) {
    this.articles = articles;
    this.locale = locale;
    this.content = content;
    this.contentType = contentType;
    this.description = description;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code contentType} attribute
   */
  @JsonProperty("contentType")
  @Override
  public String getContentType() {
    return contentType;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Link#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLink(newValue, this.locale, this.content, this.contentType, this.description);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Link#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLink withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLink(newValue, this.locale, this.content, this.contentType, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableLink(this.articles, newValue, this.content, this.contentType, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableLink(this.articles, this.locale, newValue, this.contentType, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getContentType() contentType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withContentType(String value) {
    String newValue = Objects.requireNonNull(value, "contentType");
    if (this.contentType.equals(newValue)) return this;
    return new ImmutableLink(this.articles, this.locale, this.content, newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Link#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLink withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableLink(this.articles, this.locale, this.content, this.contentType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLink
        && equalTo((ImmutableLink) another);
  }

  private boolean equalTo(ImmutableLink another) {
    return articles.equals(another.articles)
        && locale.equals(another.locale)
        && content.equals(another.content)
        && contentType.equals(another.contentType)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code articles}, {@code locale}, {@code content}, {@code contentType}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + contentType.hashCode();
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Link} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Link")
        .omitNullValues()
        .add("articles", articles)
        .add("locale", locale)
        .add("content", content)
        .add("contentType", contentType)
        .add("description", description)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Link", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Link {
    @Nullable List<String> articles = ImmutableList.of();
    @Nullable String locale;
    @Nullable String content;
    @Nullable String contentType;
    @Nullable String description;
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty("contentType")
    public void setContentType(String contentType) {
      this.contentType = contentType;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
    @Override
    public String getContentType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLink fromJson(Json json) {
    ImmutableLink.Builder builder = ImmutableLink.builder();
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.contentType != null) {
      builder.contentType(json.contentType);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Link} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Link instance
   */
  public static ImmutableLink copyOf(StencilClient.Link instance) {
    if (instance instanceof ImmutableLink) {
      return (ImmutableLink) instance;
    }
    return ImmutableLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLink ImmutableLink}.
   * <pre>
   * ImmutableLink.builder()
   *    .addArticles|addAllArticles(String) // {@link StencilClient.Link#getArticles() articles} elements
   *    .locale(String) // required {@link StencilClient.Link#getLocale() locale}
   *    .content(String) // required {@link StencilClient.Link#getContent() content}
   *    .contentType(String) // required {@link StencilClient.Link#getContentType() contentType}
   *    .description(String) // required {@link StencilClient.Link#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableLink builder
   */
  public static ImmutableLink.Builder builder() {
    return new ImmutableLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLink ImmutableLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Link", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LOCALE = 0x1L;
    private static final long INIT_BIT_CONTENT = 0x2L;
    private static final long INIT_BIT_CONTENT_TYPE = 0x4L;
    private static final long INIT_BIT_DESCRIPTION = 0x8L;
    private long initBits = 0xfL;

    private ImmutableList.Builder<String> articles = ImmutableList.builder();
    private @Nullable String locale;
    private @Nullable String content;
    private @Nullable String contentType;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Link} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Link instance) {
      Objects.requireNonNull(instance, "instance");
      addAllArticles(instance.getArticles());
      locale(instance.getLocale());
      content(instance.getContent());
      contentType(instance.getContentType());
      description(instance.getDescription());
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Link#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Link#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Link#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Link#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getContentType() contentType} attribute.
     * @param contentType The value for contentType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contentType")
    public final Builder contentType(String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType");
      initBits &= ~INIT_BIT_CONTENT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Link#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLink ImmutableLink}.
     * @return An immutable instance of Link
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLink build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLink(articles.build(), locale, content, contentType, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      if ((initBits & INIT_BIT_CONTENT_TYPE) != 0) attributes.add("contentType");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build Link, some of required attributes are not set " + attributes;
    }
  }
}
