/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.LinkMutator", generator="Immutables")
@Immutable
public final class ImmutableLinkMutator
implements UpdateBuilder.LinkMutator {
    private final String linkId;
    private final String content;
    private final String locale;
    private final String description;
    private final String type;
    private final ImmutableList<String> articles;

    private ImmutableLinkMutator(String linkId, String content, String locale, String description, String type, ImmutableList<String> articles) {
        this.linkId = linkId;
        this.content = content;
        this.locale = locale;
        this.description = description;
        this.type = type;
        this.articles = articles;
    }

    @Override
    @JsonProperty(value="linkId")
    public String getLinkId() {
        return this.linkId;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    public final ImmutableLinkMutator withLinkId(String value) {
        String newValue = Objects.requireNonNull(value, "linkId");
        if (this.linkId.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(newValue, this.content, this.locale, this.description, this.type, this.articles);
    }

    public final ImmutableLinkMutator withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(this.linkId, newValue, this.locale, this.description, this.type, this.articles);
    }

    public final ImmutableLinkMutator withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(this.linkId, this.content, newValue, this.description, this.type, this.articles);
    }

    public final ImmutableLinkMutator withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(this.linkId, this.content, this.locale, newValue, this.type, this.articles);
    }

    public final ImmutableLinkMutator withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(this.linkId, this.content, this.locale, this.description, newValue, this.articles);
    }

    public final ImmutableLinkMutator withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLinkMutator(this.linkId, this.content, this.locale, this.description, this.type, (ImmutableList<String>)newValue);
    }

    public final ImmutableLinkMutator withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLinkMutator(this.linkId, this.content, this.locale, this.description, this.type, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkMutator && this.equalTo((ImmutableLinkMutator)another);
    }

    private boolean equalTo(ImmutableLinkMutator another) {
        return this.linkId.equals(another.linkId) && this.content.equals(another.content) && this.locale.equals(another.locale) && this.description.equals(another.description) && this.type.equals(another.type) && this.articles.equals(another.articles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.linkId.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.articles.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LinkMutator").omitNullValues().add("linkId", (Object)this.linkId).add("content", (Object)this.content).add("locale", (Object)this.locale).add("description", (Object)this.description).add("type", (Object)this.type).add("articles", this.articles).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLinkMutator fromJson(Json json) {
        Builder builder = ImmutableLinkMutator.builder();
        if (json.linkId != null) {
            builder.linkId(json.linkId);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        return builder.build();
    }

    public static ImmutableLinkMutator copyOf(UpdateBuilder.LinkMutator instance) {
        if (instance instanceof ImmutableLinkMutator) {
            return (ImmutableLinkMutator)instance;
        }
        return ImmutableLinkMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.LinkMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LINK_ID = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private static final long INIT_BIT_LOCALE = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String linkId;
        @Nullable
        private String content;
        @Nullable
        private String locale;
        @Nullable
        private String description;
        @Nullable
        private String type;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.LinkMutator instance) {
            Objects.requireNonNull(instance, "instance");
            this.linkId(instance.getLinkId());
            this.content(instance.getContent());
            this.locale(instance.getLocale());
            this.description(instance.getDescription());
            this.type(instance.getType());
            this.addAllArticles(instance.getArticles());
            return this;
        }

        @JsonProperty(value="linkId")
        @CanIgnoreReturnValue
        public final Builder linkId(String linkId) {
            this.linkId = Objects.requireNonNull(linkId, "linkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        public ImmutableLinkMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkMutator(this.linkId, this.content, this.locale, this.description, this.type, (ImmutableList<String>)this.articles.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("linkId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build LinkMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.LinkMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.LinkMutator {
        @Nullable
        String linkId;
        @Nullable
        String content;
        @Nullable
        String locale;
        @Nullable
        String description;
        @Nullable
        String type;
        @Nullable
        List<String> articles = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="linkId")
        public void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @Override
        public String getLinkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }
    }
}

