package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreateWorkflow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateWorkflow.builder()}.
 */
@Generated(from = "CreateBuilder.CreateWorkflow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateWorkflow implements CreateBuilder.CreateWorkflow {
  private final String name;
  private final String locale;
  private final String content;
  private final ImmutableList<String> articles;

  private ImmutableCreateWorkflow(
      String name,
      String locale,
      String content,
      ImmutableList<String> articles) {
    this.name = name;
    this.locale = locale;
    this.content = content;
    this.articles = articles;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateWorkflow#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateWorkflow withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCreateWorkflow(newValue, this.locale, this.content, this.articles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateWorkflow#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateWorkflow withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableCreateWorkflow(this.name, newValue, this.content, this.articles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateWorkflow#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateWorkflow withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableCreateWorkflow(this.name, this.locale, newValue, this.articles);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.CreateWorkflow#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateWorkflow withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateWorkflow(this.name, this.locale, this.content, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.CreateWorkflow#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateWorkflow withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateWorkflow(this.name, this.locale, this.content, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateWorkflow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateWorkflow
        && equalTo((ImmutableCreateWorkflow) another);
  }

  private boolean equalTo(ImmutableCreateWorkflow another) {
    return name.equals(another.name)
        && locale.equals(another.locale)
        && content.equals(another.content)
        && articles.equals(another.articles);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code locale}, {@code content}, {@code articles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + articles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateWorkflow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateWorkflow")
        .omitNullValues()
        .add("name", name)
        .add("locale", locale)
        .add("content", content)
        .add("articles", articles)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreateWorkflow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreateWorkflow {
    @Nullable String name;
    @Nullable String locale;
    @Nullable String content;
    @Nullable List<String> articles = ImmutableList.of();
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateWorkflow fromJson(Json json) {
    ImmutableCreateWorkflow.Builder builder = ImmutableCreateWorkflow.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreateWorkflow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateWorkflow instance
   */
  public static ImmutableCreateWorkflow copyOf(CreateBuilder.CreateWorkflow instance) {
    if (instance instanceof ImmutableCreateWorkflow) {
      return (ImmutableCreateWorkflow) instance;
    }
    return ImmutableCreateWorkflow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateWorkflow ImmutableCreateWorkflow}.
   * <pre>
   * ImmutableCreateWorkflow.builder()
   *    .name(String) // required {@link CreateBuilder.CreateWorkflow#getName() name}
   *    .locale(String) // required {@link CreateBuilder.CreateWorkflow#getLocale() locale}
   *    .content(String) // required {@link CreateBuilder.CreateWorkflow#getContent() content}
   *    .addArticles|addAllArticles(String) // {@link CreateBuilder.CreateWorkflow#getArticles() articles} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCreateWorkflow builder
   */
  public static ImmutableCreateWorkflow.Builder builder() {
    return new ImmutableCreateWorkflow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateWorkflow ImmutableCreateWorkflow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreateWorkflow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_LOCALE = 0x2L;
    private static final long INIT_BIT_CONTENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String name;
    private @Nullable String locale;
    private @Nullable String content;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateWorkflow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreateWorkflow instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      locale(instance.getLocale());
      content(instance.getContent());
      addAllArticles(instance.getArticles());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateWorkflow#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateWorkflow#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateWorkflow#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.CreateWorkflow#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.CreateWorkflow#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.CreateWorkflow#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.CreateWorkflow#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateWorkflow ImmutableCreateWorkflow}.
     * @return An immutable instance of CreateWorkflow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateWorkflow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateWorkflow(name, locale, content, articles.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build CreateWorkflow, some of required attributes are not set " + attributes;
    }
  }
}
