package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateBuilder.ArticleMutator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArticleMutator.builder()}.
 */
@Generated(from = "UpdateBuilder.ArticleMutator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableArticleMutator implements UpdateBuilder.ArticleMutator {
  private final String articleId;
  private final @Nullable String parentId;
  private final String name;
  private final Integer order;

  private ImmutableArticleMutator(
      String articleId,
      @Nullable String parentId,
      String name,
      Integer order) {
    this.articleId = articleId;
    this.parentId = parentId;
    this.name = name;
    this.order = order;
  }

  /**
   * @return The value of the {@code articleId} attribute
   */
  @JsonProperty("articleId")
  @Override
  public String getArticleId() {
    return articleId;
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @JsonProperty("parentId")
  @Override
  public @Nullable String getParentId() {
    return parentId;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @JsonProperty("order")
  @Override
  public Integer getOrder() {
    return order;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.ArticleMutator#getArticleId() articleId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for articleId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleMutator withArticleId(String value) {
    String newValue = Objects.requireNonNull(value, "articleId");
    if (this.articleId.equals(newValue)) return this;
    return new ImmutableArticleMutator(newValue, this.parentId, this.name, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.ArticleMutator#getParentId() parentId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleMutator withParentId(@Nullable String value) {
    if (Objects.equals(this.parentId, value)) return this;
    return new ImmutableArticleMutator(this.articleId, value, this.name, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.ArticleMutator#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleMutator withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableArticleMutator(this.articleId, this.parentId, newValue, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.ArticleMutator#getOrder() order} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArticleMutator withOrder(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "order");
    if (this.order.equals(newValue)) return this;
    return new ImmutableArticleMutator(this.articleId, this.parentId, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArticleMutator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArticleMutator
        && equalTo((ImmutableArticleMutator) another);
  }

  private boolean equalTo(ImmutableArticleMutator another) {
    return articleId.equals(another.articleId)
        && Objects.equals(parentId, another.parentId)
        && name.equals(another.name)
        && order.equals(another.order);
  }

  /**
   * Computes a hash code from attributes: {@code articleId}, {@code parentId}, {@code name}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + articleId.hashCode();
    h += (h << 5) + Objects.hashCode(parentId);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + order.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ArticleMutator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ArticleMutator")
        .omitNullValues()
        .add("articleId", articleId)
        .add("parentId", parentId)
        .add("name", name)
        .add("order", order)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UpdateBuilder.ArticleMutator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UpdateBuilder.ArticleMutator {
    @Nullable String articleId;
    @Nullable String parentId;
    @Nullable String name;
    @Nullable Integer order;
    @JsonProperty("articleId")
    public void setArticleId(String articleId) {
      this.articleId = articleId;
    }
    @JsonProperty("parentId")
    public void setParentId(@Nullable String parentId) {
      this.parentId = parentId;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("order")
    public void setOrder(Integer order) {
      this.order = order;
    }
    @Override
    public String getArticleId() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getOrder() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableArticleMutator fromJson(Json json) {
    ImmutableArticleMutator.Builder builder = ImmutableArticleMutator.builder();
    if (json.articleId != null) {
      builder.articleId(json.articleId);
    }
    if (json.parentId != null) {
      builder.parentId(json.parentId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.order != null) {
      builder.order(json.order);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UpdateBuilder.ArticleMutator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ArticleMutator instance
   */
  public static ImmutableArticleMutator copyOf(UpdateBuilder.ArticleMutator instance) {
    if (instance instanceof ImmutableArticleMutator) {
      return (ImmutableArticleMutator) instance;
    }
    return ImmutableArticleMutator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArticleMutator ImmutableArticleMutator}.
   * <pre>
   * ImmutableArticleMutator.builder()
   *    .articleId(String) // required {@link UpdateBuilder.ArticleMutator#getArticleId() articleId}
   *    .parentId(String | null) // nullable {@link UpdateBuilder.ArticleMutator#getParentId() parentId}
   *    .name(String) // required {@link UpdateBuilder.ArticleMutator#getName() name}
   *    .order(Integer) // required {@link UpdateBuilder.ArticleMutator#getOrder() order}
   *    .build();
   * </pre>
   * @return A new ImmutableArticleMutator builder
   */
  public static ImmutableArticleMutator.Builder builder() {
    return new ImmutableArticleMutator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArticleMutator ImmutableArticleMutator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateBuilder.ArticleMutator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ARTICLE_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_ORDER = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String articleId;
    private @Nullable String parentId;
    private @Nullable String name;
    private @Nullable Integer order;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ArticleMutator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateBuilder.ArticleMutator instance) {
      Objects.requireNonNull(instance, "instance");
      articleId(instance.getArticleId());
      @Nullable String parentIdValue = instance.getParentId();
      if (parentIdValue != null) {
        parentId(parentIdValue);
      }
      name(instance.getName());
      order(instance.getOrder());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.ArticleMutator#getArticleId() articleId} attribute.
     * @param articleId The value for articleId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articleId")
    public final Builder articleId(String articleId) {
      this.articleId = Objects.requireNonNull(articleId, "articleId");
      initBits &= ~INIT_BIT_ARTICLE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.ArticleMutator#getParentId() parentId} attribute.
     * @param parentId The value for parentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentId")
    public final Builder parentId(@Nullable String parentId) {
      this.parentId = parentId;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.ArticleMutator#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.ArticleMutator#getOrder() order} attribute.
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("order")
    public final Builder order(Integer order) {
      this.order = Objects.requireNonNull(order, "order");
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableArticleMutator ImmutableArticleMutator}.
     * @return An immutable instance of ArticleMutator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArticleMutator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArticleMutator(articleId, parentId, name, order);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARTICLE_ID) != 0) attributes.add("articleId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORDER) != 0) attributes.add("order");
      return "Cannot build ArticleMutator, some of required attributes are not set " + attributes;
    }
  }
}
