/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.ArticleMutator", generator="Immutables")
@Immutable
public final class ImmutableArticleMutator
implements UpdateBuilder.ArticleMutator {
    private final String articleId;
    @Nullable
    private final String parentId;
    private final String name;
    private final Integer order;

    private ImmutableArticleMutator(String articleId, @Nullable String parentId, String name, Integer order) {
        this.articleId = articleId;
        this.parentId = parentId;
        this.name = name;
        this.order = order;
    }

    @Override
    @JsonProperty(value="articleId")
    public String getArticleId() {
        return this.articleId;
    }

    @Override
    @JsonProperty(value="parentId")
    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="order")
    public Integer getOrder() {
        return this.order;
    }

    public final ImmutableArticleMutator withArticleId(String value) {
        String newValue = Objects.requireNonNull(value, "articleId");
        if (this.articleId.equals(newValue)) {
            return this;
        }
        return new ImmutableArticleMutator(newValue, this.parentId, this.name, this.order);
    }

    public final ImmutableArticleMutator withParentId(@Nullable String value) {
        if (Objects.equals(this.parentId, value)) {
            return this;
        }
        return new ImmutableArticleMutator(this.articleId, value, this.name, this.order);
    }

    public final ImmutableArticleMutator withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableArticleMutator(this.articleId, this.parentId, newValue, this.order);
    }

    public final ImmutableArticleMutator withOrder(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "order");
        if (this.order.equals(newValue)) {
            return this;
        }
        return new ImmutableArticleMutator(this.articleId, this.parentId, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArticleMutator && this.equalTo((ImmutableArticleMutator)another);
    }

    private boolean equalTo(ImmutableArticleMutator another) {
        return this.articleId.equals(another.articleId) && Objects.equals(this.parentId, another.parentId) && this.name.equals(another.name) && this.order.equals(another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.articleId.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentId);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.order.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArticleMutator").omitNullValues().add("articleId", (Object)this.articleId).add("parentId", (Object)this.parentId).add("name", (Object)this.name).add("order", (Object)this.order).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArticleMutator fromJson(Json json) {
        Builder builder = ImmutableArticleMutator.builder();
        if (json.articleId != null) {
            builder.articleId(json.articleId);
        }
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.order != null) {
            builder.order(json.order);
        }
        return builder.build();
    }

    public static ImmutableArticleMutator copyOf(UpdateBuilder.ArticleMutator instance) {
        if (instance instanceof ImmutableArticleMutator) {
            return (ImmutableArticleMutator)instance;
        }
        return ImmutableArticleMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.ArticleMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARTICLE_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_ORDER = 4L;
        private long initBits = 7L;
        @Nullable
        private String articleId;
        @Nullable
        private String parentId;
        @Nullable
        private String name;
        @Nullable
        private Integer order;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.ArticleMutator instance) {
            Objects.requireNonNull(instance, "instance");
            this.articleId(instance.getArticleId());
            String parentIdValue = instance.getParentId();
            if (parentIdValue != null) {
                this.parentId(parentIdValue);
            }
            this.name(instance.getName());
            this.order(instance.getOrder());
            return this;
        }

        @JsonProperty(value="articleId")
        @CanIgnoreReturnValue
        public final Builder articleId(String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="order")
        @CanIgnoreReturnValue
        public final Builder order(Integer order) {
            this.order = Objects.requireNonNull(order, "order");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableArticleMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArticleMutator(this.articleId, this.parentId, this.name, this.order);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("articleId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("order");
            }
            return "Cannot build ArticleMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.ArticleMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.ArticleMutator {
        @Nullable
        String articleId;
        @Nullable
        String parentId;
        @Nullable
        String name;
        @Nullable
        Integer order;

        Json() {
        }

        @JsonProperty(value="articleId")
        public void setArticleId(String articleId) {
            this.articleId = articleId;
        }

        @JsonProperty(value="parentId")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="order")
        public void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public String getArticleId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getOrder() {
            throw new UnsupportedOperationException();
        }
    }
}

