/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.site.pg;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.thestencil.client.api.Serializers;
import io.thestencil.site.RuntimeConfig;
import io.thestencil.site.SiteProducer;
import io.thestencil.site.SiteRecorder;
import io.thestencil.site.pg.SiteBuildItem;
import io.thestencil.site.pg.SiteConfig;
import io.vertx.core.Handler;
import java.util.ArrayList;

public class SiteProcessor {
    SiteConfig config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("stencil-site-pg");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildtimeInit(SiteBuildItem buildItem, SiteRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(SiteProducer.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.configureBuildtimeConfig(buildItem.getServicePath())));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void runtimeInit(RuntimeConfig config, SiteBuildItem buildItem, SiteRecorder recorder, BeanContainerBuildItem beanContainer, ShutdownContextBuildItem shutdown) {
        recorder.configureRuntimeConfig(config);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void staticContentHandler(SiteBuildItem buildItem, SiteRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, BodyHandlerBuildItem body, SiteConfig config) throws Exception {
        Handler bodyHandler = body.getHandler();
        Handler handler = recorder.ideServicesHandler();
        routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(buildItem.getServicePath(), recorder.idRouteFunctionGet(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
    }

    @BuildStep
    public ReflectiveClassBuildItem reflection() throws SecurityException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> names = new ArrayList<String>();
        for (Class clazz : Serializers.VALUES) {
            Class<?>[] declaredClasses = classLoader.loadClass(clazz.getName()).getDeclaredClasses();
            names.add(clazz.getName());
            for (Class<?> decl : declaredClasses) {
                names.add(decl.getName());
            }
        }
        return new ReflectiveClassBuildItem(true, true, names.toArray(new String[0]));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void frontendBeans(SiteRecorder recorder, BuildProducer<SiteBuildItem> buildProducer, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        String servicePath = SiteProcessor.cleanPath(this.config.servicePath);
        SiteBuildItem buildItem = SiteBuildItem.builder(servicePath).build();
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(servicePath), "Stencil Postgre Site"));
        buildProducer.produce((BuildItem)buildItem);
    }

    private static String cleanPath(String value) {
        return SiteProducer.cleanPath((String)value);
    }
}

