/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.thestencil.persistence.api.ZoePersistence;
import io.thestencil.staticontent.StaticContentBeanFactory;
import io.thestencil.staticontent.StaticContentBuildItem;
import io.thestencil.staticontent.StaticContentConfig;
import io.thestencil.staticontent.StaticContentRecorder;
import io.thestencil.staticontent.api.MarkdownContent;
import io.thestencil.staticontent.api.SiteContent;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.StaticContentClientDefault;
import io.vertx.core.Handler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticContentProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticContentProcessor.class);
    private static final String FINAL_DESTINATION = "META-INF/stencil-sc-files";
    public static final String FEATURE_BUILD_ITEM = "stencil-sc";
    @Inject
    private LaunchModeBuildItem launch;
    StaticContentConfig config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_BUILD_ITEM);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void backendBeans(StaticContentBuildItem buildItem, StaticContentRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        if (this.config.siteJson.isPresent() && this.config.webjar.isPresent()) {
            throw new ConfigurationError("siteJson and webjar both can't be defined, define only one of them!");
        }
        if (this.config.siteJson.isEmpty() && this.config.webjar.isEmpty()) {
            throw new ConfigurationError("siteJson and webjar both are empty, define one of them!");
        }
        StaticContentClient.StaticContentBuilder client = StaticContentClientDefault.builder().build().from(buildItem.getContent()).imageUrl(buildItem.getUiPath()).created(System.currentTimeMillis());
        SiteContent content = client.build();
        Map<String, SiteContent.Site> contentValues = content.getSites().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (SiteContent.Site)e.getValue()));
        if (!contentValues.containsKey(this.config.defaultLocale)) {
            throw new ConfigurationError("Markdowns must have localization for default-locale: '" + this.config.defaultLocale + "'!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Supported locales: '" + String.join((CharSequence)", ", contentValues.keySet()) + "'");
        }
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(StaticContentBeanFactory.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.listener(content, this.config.defaultLocale)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void staticContentHandler(StaticContentRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, StaticContentConfig config) throws Exception {
        Handler handler = recorder.staticContentHandler();
        routes.produce((BuildItem)httpRoot.routeBuilder().route(config.servicePath).handler(handler).build());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(config.servicePath + "/*").handler(handler).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticContent(StaticContentRecorder recorder, BuildProducer<StaticContentBuildItem> buildProducer, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImage, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        if (this.config.siteJson.isPresent()) {
            this.staticJSONContent(recorder, buildProducer, generatedResources, nativeImage, nonApplicationRootPathBuildItem, curateOutcomeBuildItem, liveReloadBuildItem, httpRootPathBuildItem, displayableEndpoints);
            return;
        }
        if (this.config.webjar.isPresent()) {
            this.staticWebjarContent(recorder, buildProducer, generatedResources, nativeImage, nonApplicationRootPathBuildItem, curateOutcomeBuildItem, liveReloadBuildItem, httpRootPathBuildItem, displayableEndpoints);
            return;
        }
    }

    public void staticWebjarContent(StaticContentRecorder recorder, BuildProducer<StaticContentBuildItem> buildProducer, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImage, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(this.config.servicePath), "Zoe Static Content From Webjar"));
        String[] fragments = this.config.webjar.get().split(":");
        String webjarGroupId = fragments[0];
        String webjarArtifactId = fragments[1];
        String webjarPrefix = "META-INF/resources/webjars/" + webjarArtifactId + "/";
        AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)webjarGroupId, (String)webjarArtifactId);
        if (this.launch.getLaunchMode().isDevOrTest()) {
            Path tempPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (String)(webjarPrefix + artifact.getVersion()), (boolean)false);
            String tempAbsolutePath = tempPath.toAbsolutePath().toString();
            StaticContentClient.FileParser builder = StaticContentClientDefault.builder().build().parseFiles();
            Files.walk(tempPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    String absolutePath = file.toAbsolutePath().toString();
                    String path = absolutePath.substring(tempAbsolutePath.length() + 1);
                    byte[] bytes = FileUtil.readFileContents((InputStream)new FileInputStream(file.toFile()));
                    builder.add(path, bytes);
                }
                catch (IOException e) {
                    throw new ConfigurationError("Failed to read file: '" + file + "'!");
                }
            });
            String frontendPath = httpRootPathBuildItem.resolvePath(this.config.imagePath);
            buildProducer.produce((BuildItem)new StaticContentBuildItem(tempPath.toAbsolutePath().toString(), frontendPath, builder.build()));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(frontendPath + "/"), "Zoe Static Content From Webjar"));
            if (liveReloadBuildItem.isLiveReload() && !liveReloadBuildItem.getChangedResources().isEmpty()) {
                WebJarUtil.hotReloadBrandingChanges((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (Set)liveReloadBuildItem.getChangedResources());
            }
            return;
        }
        String frontendPath = httpRootPathBuildItem.resolvePath(this.config.imagePath);
        Map files = WebJarUtil.copyResourcesForProduction((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)(webjarPrefix + artifact.getVersion()));
        StaticContentClient.FileParser builder = StaticContentClientDefault.builder().build().parseFiles();
        for (Map.Entry file2 : files.entrySet()) {
            Object fileName = (String)file2.getKey();
            byte[] content = (byte[])file2.getValue();
            String cleanFileName = ((String)(fileName = "META-INF/stencil-sc-files/" + (String)fileName)).toLowerCase();
            if (cleanFileName.startsWith("images/")) {
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem((String)fileName, content));
                nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
            }
            builder.add((String)file2.getKey(), (byte[])file2.getValue());
        }
        buildProducer.produce((BuildItem)new StaticContentBuildItem(FINAL_DESTINATION, frontendPath, builder.build()));
    }

    public void staticJSONContent(StaticContentRecorder recorder, BuildProducer<StaticContentBuildItem> buildProducer, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImage, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        ZoePersistence.SiteState site;
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(this.config.servicePath), "Zoe Static Content From JSON"));
        Path tempPath = this.config.siteJson.get();
        if (this.launch.getLaunchMode().isDevOrTest()) {
            ZoePersistence.SiteState site2;
            try {
                InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(tempPath.toString());
                String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                site2 = StaticContentClientDefault.builder().build().parseSiteState(content);
            }
            catch (IOException e) {
                throw new ConfigurationError("Failed to read file: '" + tempPath + "'!");
            }
            MarkdownContent md = StaticContentClientDefault.builder().build().parseMd(site2);
            String frontendPath = httpRootPathBuildItem.resolvePath(this.config.imagePath);
            buildProducer.produce((BuildItem)new StaticContentBuildItem(tempPath.toAbsolutePath().toString(), frontendPath, md));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(frontendPath + "/"), "Zoe Static Content"));
            return;
        }
        String frontendPath = httpRootPathBuildItem.resolvePath(this.config.imagePath);
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(tempPath.toString());
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            site = StaticContentClientDefault.builder().build().parseSiteState(content);
        }
        catch (IOException e) {
            throw new ConfigurationError("Failed to read file: '" + tempPath + "'!");
        }
        Object fileName = tempPath.toFile().getName().toString();
        fileName = "META-INF/stencil-sc-files/" + (String)fileName;
        MarkdownContent md = StaticContentClientDefault.builder().build().parseMd(site);
        buildProducer.produce((BuildItem)new StaticContentBuildItem(FINAL_DESTINATION, frontendPath, md));
    }
}

