/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide.services;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.thestencil.persistence.api.ImmutableArticle;
import io.thestencil.persistence.api.ImmutableArticleMutator;
import io.thestencil.persistence.api.ImmutableCreateArticle;
import io.thestencil.persistence.api.ImmutableCreateLink;
import io.thestencil.persistence.api.ImmutableCreateLocale;
import io.thestencil.persistence.api.ImmutableCreatePage;
import io.thestencil.persistence.api.ImmutableCreateRelease;
import io.thestencil.persistence.api.ImmutableCreateWorkflow;
import io.thestencil.persistence.api.ImmutableEntity;
import io.thestencil.persistence.api.ImmutableLink;
import io.thestencil.persistence.api.ImmutableLinkArticlePage;
import io.thestencil.persistence.api.ImmutableLinkMutator;
import io.thestencil.persistence.api.ImmutableLocale;
import io.thestencil.persistence.api.ImmutableLocaleMutator;
import io.thestencil.persistence.api.ImmutablePage;
import io.thestencil.persistence.api.ImmutablePageMutator;
import io.thestencil.persistence.api.ImmutableRelease;
import io.thestencil.persistence.api.ImmutableSiteState;
import io.thestencil.persistence.api.ImmutableWorkflow;
import io.thestencil.persistence.api.ImmutableWorkflowArticlePage;
import io.thestencil.persistence.api.ImmutableWorkflowMutator;
import io.thestencil.quarkus.ide.services.IDEServicesBuildItem;
import io.thestencil.quarkus.ide.services.IDEServicesConfig;
import io.thestencil.quarkus.ide.services.IDEServicesProducer;
import io.thestencil.quarkus.ide.services.IDEServicesRecorder;
import io.thestencil.quarkus.ide.services.RuntimeConfig;
import io.vertx.core.Handler;
import java.util.function.Consumer;

public class IDEServicesProcessor {
    IDEServicesConfig config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("stencil-ide-services");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildtimeInit(IDEServicesBuildItem buildItem, IDEServicesRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(IDEServicesProducer.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.configureBuildtimeConfig(buildItem.getServicePath(), buildItem.getArticlesPath(), buildItem.getPagesPath(), buildItem.getWorkflowsPath(), buildItem.getLinksPath(), buildItem.getReleasesPath(), buildItem.getLocalePath())));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void runtimeInit(RuntimeConfig config, IDEServicesBuildItem buildItem, IDEServicesRecorder recorder, BeanContainerBuildItem beanContainer, ShutdownContextBuildItem shutdown) {
        recorder.configureRuntimeConfig(config);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void staticContentHandler(IDEServicesBuildItem buildItem, IDEServicesRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, BodyHandlerBuildItem body, IDEServicesConfig config) throws Exception {
        Handler bodyHandler = body.getHandler();
        Handler handler = recorder.ideServicesHandler();
        Consumer<String> addRoute = path -> {
            routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(path, recorder.routeFunction(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
            routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(path + "/", recorder.routeFunction(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
            routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(path + "/:id", recorder.idRouteFunctionDelete(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
        };
        addRoute.accept(buildItem.getServicePath());
        addRoute.accept(buildItem.getArticlesPath());
        addRoute.accept(buildItem.getPagesPath());
        addRoute.accept(buildItem.getLinksPath());
        addRoute.accept(buildItem.getLocalePath());
        addRoute.accept(buildItem.getReleasesPath());
        addRoute.accept(buildItem.getWorkflowsPath());
        routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(buildItem.getReleasesPath() + "/:id", recorder.idRouteFunctionGet(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
        routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(buildItem.getLinksPath() + "/:id?:articleId", recorder.idRouteFunctionDelete(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
        routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(buildItem.getWorkflowsPath() + "/:id?:articleId", recorder.idRouteFunctionDelete(bodyHandler)).handler(handler).displayOnNotFoundPage().build());
    }

    @BuildStep
    public ReflectiveClassBuildItem reflection() {
        return new ReflectiveClassBuildItem(true, true, new Class[]{ImmutableSiteState.class, ImmutableArticle.class, ImmutableArticleMutator.class, ImmutableCreateArticle.class, ImmutableCreateLink.class, ImmutableCreateLocale.class, ImmutableCreatePage.class, ImmutableCreateRelease.class, ImmutableCreateWorkflow.class, ImmutableEntity.class, ImmutableLink.class, ImmutableLinkArticlePage.class, ImmutableLinkMutator.class, ImmutableLocale.class, ImmutableLocaleMutator.class, ImmutablePage.class, ImmutablePageMutator.class, ImmutableRelease.class, ImmutableWorkflow.class, ImmutableWorkflowArticlePage.class, ImmutableWorkflowMutator.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void frontendBeans(IDEServicesRecorder recorder, BuildProducer<IDEServicesBuildItem> buildProducer, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        String servicePath = IDEServicesProcessor.cleanPath(this.config.servicePath);
        IDEServicesBuildItem buildItem = IDEServicesBuildItem.builder(servicePath).articlesPath("articles").pagesPath("pages").localePath("locales").workflowsPath("workflows").linksPath("links").releasesPath("releases").build();
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(servicePath), "Stencil Actions"));
        buildProducer.produce((BuildItem)buildItem);
    }

    private static String cleanPath(String value) {
        return IDEServicesProducer.cleanPath((String)value);
    }
}

