/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.iam.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.thestencil.iam.api.ImmutableAddress;
import io.thestencil.iam.api.ImmutableContact;
import io.thestencil.iam.api.ImmutableRepresentedCompany;
import io.thestencil.iam.api.ImmutableRepresentedPerson;
import io.thestencil.iam.api.ImmutableUser;
import io.thestencil.iam.api.ImmutableUserLiveness;
import io.thestencil.iam.api.ImmutableUserQueryResult;
import io.thestencil.iam.api.ImmutableUserRoles;
import io.thestencil.iam.api.ImmutableUserRolesPrincipal;
import io.thestencil.iam.api.ImmutableUserRolesResult;
import io.thestencil.quarkus.iam.IAMBeanFactory;
import io.thestencil.quarkus.iam.IAMRecorder;
import io.thestencil.quarkus.iam.RuntimeConfig;
import io.thestencil.quarkus.iam.deployment.IAMBuildItem;
import io.thestencil.quarkus.iam.deployment.IAMConfig;
import io.vertx.core.Handler;

public class IAMProcessor {
    IAMConfig config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("user-iam");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildtimeInit(IAMBuildItem buildItem, IAMRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(IAMBeanFactory.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.buildtimeConfig(buildItem.getServicePath())));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void runtimeInit(RuntimeConfig config, IAMBuildItem buildItem, IAMRecorder recorder, BeanContainerBuildItem beanContainer, ShutdownContextBuildItem shutdown) {
        recorder.runtimeConfig(config);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void staticContentHandler(IAMBuildItem buildItem, IAMRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, IAMConfig config) throws Exception {
        Handler handler = recorder.iamHandler(buildItem.getLivenessPath(), buildItem.getRolesPath());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(config.servicePath).handler(handler).build());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(config.servicePath + "/*").handler(handler).build());
    }

    @BuildStep
    public ReflectiveClassBuildItem reflection() {
        return new ReflectiveClassBuildItem(true, true, new Class[]{ImmutableRepresentedPerson.class, ImmutableRepresentedCompany.class, ImmutableUserRoles.class, ImmutableUserRolesResult.class, ImmutableUserRolesPrincipal.class, ImmutableUser.class, ImmutableAddress.class, ImmutableContact.class, ImmutableUserLiveness.class, ImmutableUserQueryResult.class});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void frontendBeans(IAMRecorder recorder, BuildProducer<IAMBuildItem> buildProducer, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        String userPath = httpRootPathBuildItem.resolvePath(this.config.servicePath);
        String livenessPath = httpRootPathBuildItem.resolvePath(this.config.servicePath + "/liveness");
        String rolesPath = httpRootPathBuildItem.resolvePath(this.config.servicePath + "/roles");
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(userPath, "User IAM"));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(livenessPath, "User IAM Liveness"));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(rolesPath, "User IAM Roles"));
        buildProducer.produce((BuildItem)new IAMBuildItem(this.config.servicePath, livenessPath, rolesPath));
    }
}

