/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.DeleteBuilder;
import io.thestencil.client.api.ImmutableArticleMutator;
import io.thestencil.client.api.ImmutableCreateArticle;
import io.thestencil.client.api.ImmutableCreateLink;
import io.thestencil.client.api.ImmutableCreateLocale;
import io.thestencil.client.api.ImmutableCreatePage;
import io.thestencil.client.api.ImmutableCreateRelease;
import io.thestencil.client.api.ImmutableCreateTemplate;
import io.thestencil.client.api.ImmutableCreateWorkflow;
import io.thestencil.client.api.ImmutableLinkArticlePage;
import io.thestencil.client.api.ImmutableLinkMutator;
import io.thestencil.client.api.ImmutableLocaleMutator;
import io.thestencil.client.api.ImmutableSiteState;
import io.thestencil.client.api.ImmutableTemplateMutator;
import io.thestencil.client.api.ImmutableWorkflowArticlePage;
import io.thestencil.client.api.ImmutableWorkflowMutator;
import io.thestencil.client.api.Markdowns;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.UpdateBuilder;
import io.thestencil.client.spi.beans.SitesBean;
import io.thestencil.client.spi.composer.HandlerStatusCodes;
import io.thestencil.quarkus.ide.services.HandlerContext;
import io.thestencil.quarkus.ide.services.HandlerTemplate;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerComposer
extends HandlerTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerComposer.class);

    public HandlerComposer(CurrentIdentityAssociation currentIdentityAssociation, CurrentVertxRequest currentVertxRequest) {
        super(currentIdentityAssociation, currentVertxRequest);
    }

    @Override
    protected void handleResource(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) throws IOException {
        response.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
        String path = this.getPath(event);
        if (path.endsWith(ctx.getPaths().getServicePath())) {
            this.doSite(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getMigrationPath())) {
            this.doMigration(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getArticlesPath())) {
            this.doArticles(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getLinksPath())) {
            this.doLinks(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getLocalePath())) {
            this.doLocales(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getReleasesPath())) {
            this.doReleases(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getTemplatesPath())) {
            this.doTemplates(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getWorkflowsPath())) {
            this.doWorkflows(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getPagesPath())) {
            this.doPages(event, response, ctx, objectMapper);
        } else if (path.startsWith(ctx.getPaths().getVersionPath())) {
            this.doVersion(event, response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported action", (HttpServerResponse)response);
        }
    }

    public String getPath(RoutingContext event) {
        String path = event.normalizedPath();
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public void doSite(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            client.create().repo().onItem().transform(data -> JsonObject.mapFrom((Object)data).toBuffer()).onFailure().invoke(e -> HandlerStatusCodes.catch422((Throwable)e, (HttpServerResponse)response)).subscribe().with(data -> response.end(data));
        } else if (event.request().method() == HttpMethod.GET) {
            this.subscribe(client.query().head(), response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported repository action", (HttpServerResponse)response);
        }
    }

    public void doArticles(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().article((CreateBuilder.CreateArticle)this.read(event, objectMapper, ImmutableCreateArticle.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.PUT) {
            this.subscribe(client.update().article((UpdateBuilder.ArticleMutator)this.read(event, objectMapper, ImmutableArticleMutator.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.DELETE) {
            this.subscribe(client.delete().article(event.pathParam("id")), response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported article action", (HttpServerResponse)response);
        }
    }

    public void doLinks(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().link((CreateBuilder.CreateLink)this.read(event, objectMapper, ImmutableCreateLink.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.PUT) {
            this.subscribe(client.update().link((UpdateBuilder.LinkMutator)this.read(event, objectMapper, ImmutableLinkMutator.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.DELETE) {
            String linkId = event.pathParam("id");
            List articleId = event.queryParam("articleId");
            if (articleId.isEmpty()) {
                this.subscribe(client.delete().link(linkId), response, ctx, objectMapper);
            } else {
                this.subscribe(client.delete().linkArticlePage((DeleteBuilder.LinkArticlePage)ImmutableLinkArticlePage.builder().articleId((String)articleId.iterator().next()).linkId(linkId).build()), response, ctx, objectMapper);
            }
        } else {
            HandlerStatusCodes.catch404((String)"unsupported links action", (HttpServerResponse)response);
        }
    }

    public void doTemplates(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().template((CreateBuilder.CreateTemplate)this.read(event, objectMapper, ImmutableCreateTemplate.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.PUT) {
            this.subscribe(client.update().template((UpdateBuilder.TemplateMutator)this.read(event, objectMapper, ImmutableTemplateMutator.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.DELETE) {
            this.subscribe(client.delete().template(event.pathParam("id")), response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported template action", (HttpServerResponse)response);
        }
    }

    public void doReleases(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().release((CreateBuilder.CreateRelease)this.read(event, objectMapper, ImmutableCreateRelease.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.GET) {
            this.subscribe(client.query().release(event.pathParam("id")), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.DELETE) {
            this.subscribe(client.delete().release(event.pathParam("id")), response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported release action", (HttpServerResponse)response);
        }
    }

    public void doLocales(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().locale((CreateBuilder.CreateLocale)this.read(event, objectMapper, ImmutableCreateLocale.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.PUT) {
            this.subscribe(client.update().locale((UpdateBuilder.LocaleMutator)this.read(event, objectMapper, ImmutableLocaleMutator.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.DELETE) {
            this.subscribe(client.delete().locale(event.pathParam("id")), response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported locale action", (HttpServerResponse)response);
        }
    }

    public void doWorkflows(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().workflow((CreateBuilder.CreateWorkflow)this.read(event, objectMapper, ImmutableCreateWorkflow.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.PUT) {
            this.subscribe(client.update().workflow((UpdateBuilder.WorkflowMutator)this.read(event, objectMapper, ImmutableWorkflowMutator.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.DELETE) {
            String workflowId = event.pathParam("id");
            List articleId = event.queryParam("articleId");
            if (articleId.isEmpty()) {
                this.subscribe(client.delete().workflow(workflowId), response, ctx, objectMapper);
            } else {
                this.subscribe(client.delete().workflowArticlePage((DeleteBuilder.WorkflowArticlePage)ImmutableWorkflowArticlePage.builder().articleId((String)articleId.iterator().next()).workflowId(workflowId).build()), response, ctx, objectMapper);
            }
        } else {
            HandlerStatusCodes.catch404((String)"unsupported workflow action", (HttpServerResponse)response);
        }
    }

    public void doPages(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            this.subscribe(client.create().page((CreateBuilder.CreatePage)this.read(event, objectMapper, ImmutableCreatePage.class)), response, ctx, objectMapper);
        } else if (event.request().method() == HttpMethod.PUT) {
            try {
                List pages = (List)objectMapper.readValue(event.getBody().getBytes(), (TypeReference)new TypeReference<List<UpdateBuilder.PageMutator>>(){});
                this.subscribe(client.update().pages(pages), response, ctx, objectMapper);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else if (event.request().method() == HttpMethod.DELETE) {
            this.subscribe(client.delete().page(event.pathParam("id")), response, ctx, objectMapper);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported page action", (HttpServerResponse)response);
        }
    }

    public void doMigration(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.POST) {
            byte[] body = event.getBody().getBytes();
            MigrationBuilder.Sites sites = this.parseSites(ctx, body, objectMapper);
            if (sites != null) {
                this.subscribe(client.migration().importData(sites), response, ctx, objectMapper);
                return;
            }
            StencilComposer.SiteState release = this.parseSiteState(body, objectMapper);
            if (release != null) {
                this.subscribe(client.migration().importData(release), response, ctx, objectMapper);
                return;
            }
            HandlerStatusCodes.catch422((String)"No static content or release to parse", (HttpServerResponse)response);
        } else {
            HandlerStatusCodes.catch404((String)"unsupported migration action", (HttpServerResponse)response);
        }
    }

    public void doVersion(RoutingContext event, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) throws IOException {
        StencilComposer client = ctx.getClient();
        if (event.request().method() == HttpMethod.GET) {
            StencilClient.VersionInfo version = client.version().version();
            response.end(objectMapper.writeValueAsString((Object)version));
        } else {
            HandlerStatusCodes.catch404((String)"unsupported version action", (HttpServerResponse)response);
        }
    }

    private StencilComposer.SiteState parseSiteState(byte[] body, ObjectMapper objectMapper) {
        try {
            return (StencilComposer.SiteState)objectMapper.readValue(body, ImmutableSiteState.class);
        }
        catch (IOException ex1) {
            LOGGER.error("failed to parse site for migration, " + ex1.getMessage(), (Throwable)ex1);
            return null;
        }
    }

    private MigrationBuilder.Sites parseSites(HandlerContext ctx, byte[] body, ObjectMapper objectMapper) {
        StencilComposer client = ctx.getClient();
        MigrationBuilder.Sites site = null;
        try {
            site = (MigrationBuilder.Sites)objectMapper.readValue(body, SitesBean.class);
            if (site == null || site.getSites() == null || site.getSites().isEmpty()) {
                Markdowns md = client.markdown().json(new String(body, StandardCharsets.UTF_8), true).build();
                site = client.sites().imagePath("/images").created(1L).source(md).build();
            }
            return site;
        }
        catch (IOException ex1) {
            LOGGER.error("failed to parse site for migration, " + ex1.getMessage(), (Throwable)ex1);
            return null;
        }
    }

    public <T> T read(RoutingContext event, ObjectMapper objectMapper, Class<T> type) {
        try {
            return (T)objectMapper.readValue(event.getBody().getBytes(), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> List<T> readList(RoutingContext event, ObjectMapper objectMapper, Class<T> type) {
        try {
            return (List)objectMapper.readValue(event.getBody().getBytes(), new TypeReference<List<T>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> void subscribe(Uni<T> uni, HttpServerResponse response, HandlerContext ctx, ObjectMapper objectMapper) {
        uni.onItem().transform(data -> {
            try {
                return Buffer.buffer((byte[])objectMapper.writeValueAsBytes(data));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).onFailure().invoke(e -> HandlerStatusCodes.catch422((Throwable)e, (HttpServerResponse)response)).subscribe().with(data -> response.end(data));
    }
}

