/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide.services;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.spi.pgsql.DocDBFactory;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.spi.PersistenceConfig;
import io.thestencil.client.spi.StencilClientImpl;
import io.thestencil.client.spi.serializers.ZoeDeserializer;
import io.thestencil.client.web.HandlerContext;
import io.thestencil.client.web.ServicesPathConfig;
import io.thestencil.quarkus.ide.services.RuntimeConfig;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.pgclient.PgPool;
import java.io.IOException;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;

@ApplicationScoped
public class IDEServicesProducer {
    private RuntimeConfig runtimeConfig;
    private String servicePath;
    private String articlesPath;
    private String pagesPath;
    private String workflowsPath;
    private String linksPath;
    private String releasesPath;
    private String templatesPath;
    private String localePath;
    private String migrationPath;

    public IDEServicesProducer setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
        return this;
    }

    @Produces
    @ApplicationScoped
    public RegisterGuava registerGuava() {
        return new RegisterGuava();
    }

    @Produces
    @ApplicationScoped
    public HandlerContext stencilIdeServicesContext(Vertx vertx, ObjectMapper objectMapper, PgPool pgPool) {
        ServicesPathConfig paths = ServicesPathConfig.builder().articlesPath(this.articlesPath).migrationPath(this.migrationPath).servicePath(this.servicePath).pagesPath(this.pagesPath).workflowsPath(this.workflowsPath).linksPath(this.linksPath).localePath(this.localePath).releasesPath(this.releasesPath).templatesPath(this.templatesPath).build();
        DocDB docDb = DocDBFactory.create().client(pgPool).build();
        ZoeDeserializer deserializer = new ZoeDeserializer(objectMapper);
        StencilClientImpl client = StencilClientImpl.builder().config(builder -> builder.client(docDb).repoName(this.runtimeConfig.repo.repoName).headName(this.runtimeConfig.repo.headName).deserializer((PersistenceConfig.Deserializer)deserializer).serializer(entity -> {
            try {
                return objectMapper.writeValueAsString((Object)entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).gidProvider(type -> UUID.randomUUID().toString()).authorProvider(() -> "no-author")).build();
        return new HandlerContext((StencilClient)client, paths);
    }

    public static String cleanPath(String value) {
        String start = value.startsWith("/") ? value.substring(1) : value;
        return start.endsWith("/") ? value.substring(0, start.length() - 2) : start;
    }

    public IDEServicesProducer setServicePath(String servicePath) {
        this.servicePath = servicePath;
        return this;
    }

    public IDEServicesProducer setArticlesPath(String articlesPath) {
        this.articlesPath = articlesPath;
        return this;
    }

    public IDEServicesProducer setPagesPath(String pagesPath) {
        this.pagesPath = pagesPath;
        return this;
    }

    public IDEServicesProducer setWorkflowsPath(String workflowsPath) {
        this.workflowsPath = workflowsPath;
        return this;
    }

    public IDEServicesProducer setLinksPath(String linksPath) {
        this.linksPath = linksPath;
        return this;
    }

    public IDEServicesProducer setReleasesPath(String releasesPath) {
        this.releasesPath = releasesPath;
        return this;
    }

    public IDEServicesProducer setLocalePath(String localePath) {
        this.localePath = localePath;
        return this;
    }

    public IDEServicesProducer setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
        return this;
    }

    public IDEServicesProducer setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
        return this;
    }

    @Singleton
    public static class RegisterGuava
    implements ObjectMapperCustomizer {
        public void customize(ObjectMapper objectMapper) {
            objectMapper.registerModule((Module)new GuavaModule());
        }
    }
}

