/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide.services;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.resys.thena.docdb.api.DocDB;
import io.resys.thena.docdb.spi.pgsql.DocDBFactory;
import io.thestencil.persistence.api.ImmutableArticle;
import io.thestencil.persistence.api.ImmutableArticleMutator;
import io.thestencil.persistence.api.ImmutableCreateArticle;
import io.thestencil.persistence.api.ImmutableCreateLink;
import io.thestencil.persistence.api.ImmutableCreateLocale;
import io.thestencil.persistence.api.ImmutableCreatePage;
import io.thestencil.persistence.api.ImmutableCreateRelease;
import io.thestencil.persistence.api.ImmutableCreateWorkflow;
import io.thestencil.persistence.api.ImmutableEntity;
import io.thestencil.persistence.api.ImmutableLink;
import io.thestencil.persistence.api.ImmutableLinkArticlePage;
import io.thestencil.persistence.api.ImmutableLinkMutator;
import io.thestencil.persistence.api.ImmutableLocale;
import io.thestencil.persistence.api.ImmutableLocaleMutator;
import io.thestencil.persistence.api.ImmutablePage;
import io.thestencil.persistence.api.ImmutablePageMutator;
import io.thestencil.persistence.api.ImmutableRelease;
import io.thestencil.persistence.api.ImmutableSiteState;
import io.thestencil.persistence.api.ImmutableWorkflow;
import io.thestencil.persistence.api.ImmutableWorkflowArticlePage;
import io.thestencil.persistence.api.ImmutableWorkflowMutator;
import io.thestencil.persistence.api.ZoePersistence;
import io.thestencil.persistence.spi.PersistenceConfig;
import io.thestencil.persistence.spi.ZoePersistenceImpl;
import io.thestencil.persistence.spi.serializers.ZoeDeserializer;
import io.thestencil.quarkus.ide.services.IDEServicesContext;
import io.thestencil.quarkus.ide.services.RuntimeConfig;
import io.thestencil.quarkus.ide.services.ServicesPathConfig;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.pgclient.PgPool;
import java.io.IOException;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;

@ApplicationScoped
@RegisterForReflection(targets={ImmutableSiteState.class, ImmutableArticle.class, ImmutableArticleMutator.class, ImmutableCreateArticle.class, ImmutableCreateLink.class, ImmutableCreateLocale.class, ImmutableCreatePage.class, ImmutableCreateRelease.class, ImmutableCreateWorkflow.class, ImmutableEntity.class, ImmutableLink.class, ImmutableLinkArticlePage.class, ImmutableLinkMutator.class, ImmutableLocale.class, ImmutableLocaleMutator.class, ImmutablePage.class, ImmutablePageMutator.class, ImmutableRelease.class, ImmutableWorkflow.class, ImmutableWorkflowArticlePage.class, ImmutableWorkflowMutator.class})
public class IDEServicesProducer {
    private RuntimeConfig runtimeConfig;
    private String servicePath;
    private String articlesPath;
    private String pagesPath;
    private String workflowsPath;
    private String linksPath;
    private String releasesPath;
    private String localePath;

    public IDEServicesProducer setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
        return this;
    }

    @Produces
    @ApplicationScoped
    public RegisterGuava registerGuava() {
        return new RegisterGuava();
    }

    @Produces
    @ApplicationScoped
    public IDEServicesContext stencilIdeServicesContext(Vertx vertx, ObjectMapper objectMapper, PgPool pgPool) {
        ServicesPathConfig paths = ServicesPathConfig.builder().articlesPath(this.articlesPath).servicePath(this.servicePath).pagesPath(this.pagesPath).workflowsPath(this.workflowsPath).linksPath(this.linksPath).localePath(this.localePath).releasesPath(this.releasesPath).build();
        DocDB docDb = DocDBFactory.create().client(pgPool).build();
        ZoeDeserializer deserializer = new ZoeDeserializer(objectMapper);
        ZoePersistenceImpl client = ZoePersistenceImpl.builder().config(builder -> builder.client(docDb).repoName(this.runtimeConfig.repo.repoName).headName(this.runtimeConfig.repo.headName).deserializer((PersistenceConfig.Deserializer)deserializer).serializer(entity -> {
            try {
                return objectMapper.writeValueAsString((Object)entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }).gidProvider(type -> UUID.randomUUID().toString()).authorProvider(() -> "no-author")).build();
        return new IDEServicesContext((ZoePersistence)client, paths);
    }

    public static String cleanPath(String value) {
        String start = value.startsWith("/") ? value.substring(1) : value;
        return start.endsWith("/") ? value.substring(0, start.length() - 2) : start;
    }

    public IDEServicesProducer setServicePath(String servicePath) {
        this.servicePath = servicePath;
        return this;
    }

    public IDEServicesProducer setArticlesPath(String articlesPath) {
        this.articlesPath = articlesPath;
        return this;
    }

    public IDEServicesProducer setPagesPath(String pagesPath) {
        this.pagesPath = pagesPath;
        return this;
    }

    public IDEServicesProducer setWorkflowsPath(String workflowsPath) {
        this.workflowsPath = workflowsPath;
        return this;
    }

    public IDEServicesProducer setLinksPath(String linksPath) {
        this.linksPath = linksPath;
        return this;
    }

    public IDEServicesProducer setReleasesPath(String releasesPath) {
        this.releasesPath = releasesPath;
        return this;
    }

    public IDEServicesProducer setLocalePath(String localePath) {
        this.localePath = localePath;
        return this;
    }

    @Singleton
    public static class RegisterGuava
    implements ObjectMapperCustomizer {
        public void customize(ObjectMapper objectMapper) {
            objectMapper.registerModule((Module)new GuavaModule());
        }
    }
}

