/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.quarkus.ide.services;

import io.quarkus.builder.item.SimpleBuildItem;

public final class IDEServicesBuildItem
extends SimpleBuildItem {
    private final String servicePath;
    private final String articlesPath;
    private final String pagesPath;
    private final String workflowsPath;
    private final String linksPath;
    private final String releasesPath;
    private final String localePath;
    private final String migrationPath;
    private final String templatesPath;
    private final String versionPath;

    public IDEServicesBuildItem(String servicePath, String migrationPath, String articlesPath, String pagesPath, String workflowsPath, String linksPath, String releasesPath, String localePath, String templatesPath, String versionPath) {
        this.servicePath = servicePath;
        this.articlesPath = articlesPath;
        this.pagesPath = pagesPath;
        this.workflowsPath = workflowsPath;
        this.linksPath = linksPath;
        this.releasesPath = releasesPath;
        this.localePath = localePath;
        this.migrationPath = migrationPath;
        this.templatesPath = templatesPath;
        this.versionPath = versionPath;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public String getArticlesPath() {
        return this.articlesPath;
    }

    public String getPagesPath() {
        return this.pagesPath;
    }

    public String getWorkflowsPath() {
        return this.workflowsPath;
    }

    public String getLinksPath() {
        return this.linksPath;
    }

    public String getReleasesPath() {
        return this.releasesPath;
    }

    public String getLocalePath() {
        return this.localePath;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public String getVersionPath() {
        return this.versionPath;
    }

    public static Builder builder(String servicePath) {
        return new Builder(servicePath);
    }

    public static class Builder {
        private final String servicePath;
        private String articlesPath;
        private String pagesPath;
        private String workflowsPath;
        private String linksPath;
        private String releasesPath;
        private String localePath;
        private String migrationPath;
        private String templatesPath;
        private String versionPath;

        public Builder(String servicePath) {
            this.servicePath = "/" + servicePath;
        }

        public Builder articlesPath(String articlesPath) {
            this.articlesPath = this.servicePath + "/" + articlesPath;
            return this;
        }

        public Builder pagesPath(String pagesPath) {
            this.pagesPath = this.servicePath + "/" + pagesPath;
            return this;
        }

        public Builder workflowsPath(String workflowsPath) {
            this.workflowsPath = this.servicePath + "/" + workflowsPath;
            return this;
        }

        public Builder linksPath(String linksPath) {
            this.linksPath = this.servicePath + "/" + linksPath;
            return this;
        }

        public Builder releasesPath(String releasesPath) {
            this.releasesPath = this.servicePath + "/" + releasesPath;
            return this;
        }

        public Builder localePath(String localePath) {
            this.localePath = this.servicePath + "/" + localePath;
            return this;
        }

        public Builder migrationPath(String migrationPath) {
            this.migrationPath = this.servicePath + "/" + migrationPath;
            return this;
        }

        public Builder templatesPath(String templatesPath) {
            this.templatesPath = this.servicePath + "/" + templatesPath;
            return this;
        }

        public Builder versionPath(String versionPath) {
            this.versionPath = this.servicePath + "/" + versionPath;
            return this;
        }

        public IDEServicesBuildItem build() {
            return new IDEServicesBuildItem(this.servicePath, this.migrationPath, this.articlesPath, this.pagesPath, this.workflowsPath, this.linksPath, this.releasesPath, this.localePath, this.templatesPath, this.versionPath);
        }
    }
}

