/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.xml;

import io.theblackbox.commons.check.Check;
import java.util.function.Function;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class XmlFunctionalAdapter<V, B>
extends XmlAdapter<V, B> {
    private final Function<V, B> unmarshallFunction;
    private final Function<B, V> marshallFunction;

    protected XmlFunctionalAdapter(Function<V, B> unmarshallFunction, Function<B, V> marshallFunction) {
        Check.that(unmarshallFunction);
        Check.that(marshallFunction);
        this.unmarshallFunction = unmarshallFunction;
        this.marshallFunction = marshallFunction;
    }

    public B unmarshal(V v) throws Exception {
        return this.unmarshallFunction.apply(v);
    }

    public V marshal(B b) throws Exception {
        return this.marshallFunction.apply(b);
    }

    public static <V, B> XmlFunctionalAdapter<V, B> marshalling(Function<B, V> function) {
        return XmlFunctionalAdapter.of(XmlFunctionalAdapter.notImplementedFunction(), function);
    }

    public static <V, B> XmlFunctionalAdapter<V, B> unmarshalling(Function<V, B> function) {
        return XmlFunctionalAdapter.of(function, XmlFunctionalAdapter.notImplementedFunction());
    }

    public static <V, B> XmlFunctionalAdapter<V, B> of(Function<V, B> unmarshallFunction, Function<B, V> marshallFunction) {
        return new XmlFunctionalAdapter<V, B>(unmarshallFunction, marshallFunction);
    }

    static <E1, E2> Function<E1, E2> notImplementedFunction() {
        return e -> {
            throw new UnsupportedOperationException("This xml marshall/unmarshall operation has not been implemented");
        };
    }
}

