/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.web.sitemap.urlset;

import io.theblackbox.commons.web.sitemap.urlset.SitemapUrlLink;
import io.theblackbox.commons.web.sitemap.xml.SitemapUrlChangeFreqXmlAdapter;
import io.theblackbox.commons.web.sitemap.xml.SitemapUrlLocalDateXmlAdapter;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import lombok.NonNull;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class SitemapUrl {
    @XmlElement(name="link", namespace="http://www.w3.org/1999/xhtml")
    @NonNull
    private List<SitemapUrlLink> sitemapUrlLinks;
    @XmlElement(name="loc")
    @NonNull
    private String loc = "/";
    @XmlElement(name="lastmod")
    @XmlJavaTypeAdapter(value=SitemapUrlLocalDateXmlAdapter.class)
    @NonNull
    private LocalDate lastModificationDate = LocalDate.now();
    @XmlElement(name="changefreq")
    @XmlJavaTypeAdapter(value=SitemapUrlChangeFreqXmlAdapter.class)
    @NonNull
    private ChangeFreq changeFrequency = ChangeFreq.DAILY;
    @XmlElement(name="priority")
    private double priority = 0.5;

    public SitemapUrl() {
    }

    public static SitemapUrlBuilder builder() {
        return new SitemapUrlBuilder();
    }

    @NonNull
    public List<SitemapUrlLink> getSitemapUrlLinks() {
        return this.sitemapUrlLinks;
    }

    @NonNull
    public String getLoc() {
        return this.loc;
    }

    @NonNull
    public LocalDate getLastModificationDate() {
        return this.lastModificationDate;
    }

    @NonNull
    public ChangeFreq getChangeFrequency() {
        return this.changeFrequency;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setSitemapUrlLinks(@NonNull List<SitemapUrlLink> sitemapUrlLinks) {
        if (sitemapUrlLinks == null) {
            throw new NullPointerException("sitemapUrlLinks");
        }
        this.sitemapUrlLinks = sitemapUrlLinks;
    }

    public void setLoc(@NonNull String loc) {
        if (loc == null) {
            throw new NullPointerException("loc");
        }
        this.loc = loc;
    }

    public void setLastModificationDate(@NonNull LocalDate lastModificationDate) {
        if (lastModificationDate == null) {
            throw new NullPointerException("lastModificationDate");
        }
        this.lastModificationDate = lastModificationDate;
    }

    public void setChangeFrequency(@NonNull ChangeFreq changeFrequency) {
        if (changeFrequency == null) {
            throw new NullPointerException("changeFrequency");
        }
        this.changeFrequency = changeFrequency;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    @ConstructorProperties(value={"sitemapUrlLinks", "loc", "lastModificationDate", "changeFrequency", "priority"})
    public SitemapUrl(@NonNull List<SitemapUrlLink> sitemapUrlLinks, @NonNull String loc, @NonNull LocalDate lastModificationDate, @NonNull ChangeFreq changeFrequency, double priority) {
        if (sitemapUrlLinks == null) {
            throw new NullPointerException("sitemapUrlLinks");
        }
        if (loc == null) {
            throw new NullPointerException("loc");
        }
        if (lastModificationDate == null) {
            throw new NullPointerException("lastModificationDate");
        }
        if (changeFrequency == null) {
            throw new NullPointerException("changeFrequency");
        }
        this.sitemapUrlLinks = sitemapUrlLinks;
        this.loc = loc;
        this.lastModificationDate = lastModificationDate;
        this.changeFrequency = changeFrequency;
        this.priority = priority;
    }

    public String toString() {
        return "SitemapUrl(sitemapUrlLinks=" + this.getSitemapUrlLinks() + ", loc=" + this.getLoc() + ", lastModificationDate=" + this.getLastModificationDate() + ", changeFrequency=" + (Object)((Object)this.getChangeFrequency()) + ", priority=" + this.getPriority() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SitemapUrl)) {
            return false;
        }
        SitemapUrl other = (SitemapUrl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SitemapUrlLink> this$sitemapUrlLinks = this.getSitemapUrlLinks();
        List<SitemapUrlLink> other$sitemapUrlLinks = other.getSitemapUrlLinks();
        if (this$sitemapUrlLinks == null ? other$sitemapUrlLinks != null : !((Object)this$sitemapUrlLinks).equals(other$sitemapUrlLinks)) {
            return false;
        }
        String this$loc = this.getLoc();
        String other$loc = other.getLoc();
        if (this$loc == null ? other$loc != null : !this$loc.equals(other$loc)) {
            return false;
        }
        LocalDate this$lastModificationDate = this.getLastModificationDate();
        LocalDate other$lastModificationDate = other.getLastModificationDate();
        if (this$lastModificationDate == null ? other$lastModificationDate != null : !((Object)this$lastModificationDate).equals(other$lastModificationDate)) {
            return false;
        }
        ChangeFreq this$changeFrequency = this.getChangeFrequency();
        ChangeFreq other$changeFrequency = other.getChangeFrequency();
        if (this$changeFrequency == null ? other$changeFrequency != null : !((Object)((Object)this$changeFrequency)).equals((Object)other$changeFrequency)) {
            return false;
        }
        return Double.compare(this.getPriority(), other.getPriority()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SitemapUrl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SitemapUrlLink> $sitemapUrlLinks = this.getSitemapUrlLinks();
        result = result * 59 + ($sitemapUrlLinks == null ? 43 : ((Object)$sitemapUrlLinks).hashCode());
        String $loc = this.getLoc();
        result = result * 59 + ($loc == null ? 43 : $loc.hashCode());
        LocalDate $lastModificationDate = this.getLastModificationDate();
        result = result * 59 + ($lastModificationDate == null ? 43 : ((Object)$lastModificationDate).hashCode());
        ChangeFreq $changeFrequency = this.getChangeFrequency();
        result = result * 59 + ($changeFrequency == null ? 43 : ((Object)((Object)$changeFrequency)).hashCode());
        long $priority = Double.doubleToLongBits(this.getPriority());
        result = result * 59 + (int)($priority >>> 32 ^ $priority);
        return result;
    }

    public static class SitemapUrlBuilder {
        private List<SitemapUrlLink> sitemapUrlLinks;
        private String loc;
        private LocalDate lastModificationDate;
        private ChangeFreq changeFrequency;
        private double priority;

        SitemapUrlBuilder() {
        }

        public SitemapUrlBuilder sitemapUrlLinks(List<SitemapUrlLink> sitemapUrlLinks) {
            this.sitemapUrlLinks = sitemapUrlLinks;
            return this;
        }

        public SitemapUrlBuilder loc(String loc) {
            this.loc = loc;
            return this;
        }

        public SitemapUrlBuilder lastModificationDate(LocalDate lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public SitemapUrlBuilder changeFrequency(ChangeFreq changeFrequency) {
            this.changeFrequency = changeFrequency;
            return this;
        }

        public SitemapUrlBuilder priority(double priority) {
            this.priority = priority;
            return this;
        }

        public SitemapUrl build() {
            return new SitemapUrl(this.sitemapUrlLinks, this.loc, this.lastModificationDate, this.changeFrequency, this.priority);
        }

        public String toString() {
            return "SitemapUrl.SitemapUrlBuilder(sitemapUrlLinks=" + this.sitemapUrlLinks + ", loc=" + this.loc + ", lastModificationDate=" + this.lastModificationDate + ", changeFrequency=" + (Object)((Object)this.changeFrequency) + ", priority=" + this.priority + ")";
        }
    }

    public static enum ChangeFreq {
        ALWAYS("always"),
        HOURLY("hourly"),
        DAILY("daily"),
        WEEKLY("weekly"),
        MONTHLY("monthly"),
        YEARLY("yearly"),
        NEVER("never");

        @NonNull
        private final String standardName;

        public static ChangeFreq fromStandardName(@NonNull String standardName) {
            if (standardName == null) {
                throw new NullPointerException("standardName");
            }
            return Arrays.asList(ChangeFreq.values()).stream().filter(v -> v.getStandardName().equals(standardName)).findFirst().orElse(null);
        }

        private ChangeFreq(String standardName) {
            if (standardName == null) {
                throw new NullPointerException("standardName");
            }
            this.standardName = standardName;
        }

        @NonNull
        public String getStandardName() {
            return this.standardName;
        }
    }
}

