/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.web.sitemap.urlset;

import lombok.NonNull;

public final class SitemapHreflang {
    @NonNull
    private final String countryIsoCode2;
    @NonNull
    private final String languageIsoCode2;

    public String asHreflang() {
        return this.languageIsoCode2.toLowerCase() + "-" + this.countryIsoCode2.toLowerCase();
    }

    SitemapHreflang(@NonNull String countryIsoCode2, @NonNull String languageIsoCode2) {
        if (countryIsoCode2 == null) {
            throw new NullPointerException("countryIsoCode2");
        }
        if (languageIsoCode2 == null) {
            throw new NullPointerException("languageIsoCode2");
        }
        this.countryIsoCode2 = countryIsoCode2;
        this.languageIsoCode2 = languageIsoCode2;
    }

    public static SitemapHreflangBuilder builder() {
        return new SitemapHreflangBuilder();
    }

    @NonNull
    public String getCountryIsoCode2() {
        return this.countryIsoCode2;
    }

    @NonNull
    public String getLanguageIsoCode2() {
        return this.languageIsoCode2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SitemapHreflang)) {
            return false;
        }
        SitemapHreflang other = (SitemapHreflang)o;
        String this$countryIsoCode2 = this.getCountryIsoCode2();
        String other$countryIsoCode2 = other.getCountryIsoCode2();
        if (this$countryIsoCode2 == null ? other$countryIsoCode2 != null : !this$countryIsoCode2.equals(other$countryIsoCode2)) {
            return false;
        }
        String this$languageIsoCode2 = this.getLanguageIsoCode2();
        String other$languageIsoCode2 = other.getLanguageIsoCode2();
        return !(this$languageIsoCode2 == null ? other$languageIsoCode2 != null : !this$languageIsoCode2.equals(other$languageIsoCode2));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $countryIsoCode2 = this.getCountryIsoCode2();
        result = result * 59 + ($countryIsoCode2 == null ? 43 : $countryIsoCode2.hashCode());
        String $languageIsoCode2 = this.getLanguageIsoCode2();
        result = result * 59 + ($languageIsoCode2 == null ? 43 : $languageIsoCode2.hashCode());
        return result;
    }

    public String toString() {
        return "SitemapHreflang(countryIsoCode2=" + this.getCountryIsoCode2() + ", languageIsoCode2=" + this.getLanguageIsoCode2() + ")";
    }

    public static class SitemapHreflangBuilder {
        private String countryIsoCode2;
        private String languageIsoCode2;

        SitemapHreflangBuilder() {
        }

        public SitemapHreflangBuilder countryIsoCode2(String countryIsoCode2) {
            this.countryIsoCode2 = countryIsoCode2;
            return this;
        }

        public SitemapHreflangBuilder languageIsoCode2(String languageIsoCode2) {
            this.languageIsoCode2 = languageIsoCode2;
            return this;
        }

        public SitemapHreflang build() {
            return new SitemapHreflang(this.countryIsoCode2, this.languageIsoCode2);
        }

        public String toString() {
            return "SitemapHreflang.SitemapHreflangBuilder(countryIsoCode2=" + this.countryIsoCode2 + ", languageIsoCode2=" + this.languageIsoCode2 + ")";
        }
    }
}

