/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.integration.slack.autoconfigure;

import io.theblackbox.commons.integration.slack.SlackService;
import io.theblackbox.commons.integration.slack.SlackSimpleService;
import io.theblackbox.commons.integration.slack.autoconfigure.SlackProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingBean(value={SlackSimpleService.class, SlackService.class})
@EnableConfigurationProperties(value={SlackProperties.class})
public class SlackServiceAutoConfiguration {
    @Autowired
    private SlackProperties properties;
    @Autowired(required=false)
    private RestTemplate restTemplate;

    @Bean
    @ConditionalOnMissingBean(value={SlackSimpleService.class})
    public SlackSimpleService slackSimpleService() {
        return new SlackSimpleService(this.getRestTemplateOrCreate());
    }

    @Bean
    @ConditionalOnMissingBean(value={SlackService.class})
    @ConditionalOnProperty(value={"slackUrl", "defaultChannel"}, prefix="slack")
    public SlackService slackService() {
        return new SlackService(this.slackSimpleService(), this.properties.getSlackUrl(), this.properties.getDefaultUsername(), this.properties.getDefaultChannel());
    }

    private RestTemplate getRestTemplateOrCreate() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
        }
        return this.restTemplate;
    }
}

