/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.integration.slack;

import io.theblackbox.commons.integration.slack.SlackMessage;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class SlackSimpleService {
    private static final Logger log = LoggerFactory.getLogger(SlackSimpleService.class);
    private final RestTemplate restTemplate;

    public void post(@NonNull String slackUrl, @NonNull String username, @NonNull String channel, @NonNull String message) {
        if (slackUrl == null) {
            throw new NullPointerException("slackUrl");
        }
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        SlackMessage slackMessage = SlackMessage.builder().username(username).channel(channel).text(message).build();
        this.post(slackUrl, slackMessage);
    }

    public void post(@NonNull String slackUrl, @NonNull SlackMessage slackMessage) {
        if (slackUrl == null) {
            throw new NullPointerException("slackUrl");
        }
        if (slackMessage == null) {
            throw new NullPointerException("slackMessage");
        }
        try {
            this.restTemplate.postForLocation(slackUrl, (Object)slackMessage, new Object[0]);
        }
        catch (Exception e) {
            log.error("Exception while posting to Slack", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"restTemplate"})
    public SlackSimpleService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

