/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.integration.slack;

import io.theblackbox.commons.integration.slack.SlackSimpleService;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class SlackService {
    private final SlackSimpleService slackSimpleService;
    private final String slackUrl;
    private final String defaultUsername;
    private final String defaultChannel;

    public void post(@NonNull String username, @NonNull String channel, @NonNull String message) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.slackSimpleService.post(this.slackUrl, username, channel, message);
    }

    public void postToDefaultChannel(@NonNull String username, @NonNull String message) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.post(username, this.defaultChannel, message);
    }

    public void post(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.post(this.defaultUsername, this.defaultChannel, message);
    }

    @ConstructorProperties(value={"slackSimpleService", "slackUrl", "defaultUsername", "defaultChannel"})
    public SlackService(SlackSimpleService slackSimpleService, String slackUrl, String defaultUsername, String defaultChannel) {
        this.slackSimpleService = slackSimpleService;
        this.slackUrl = slackUrl;
        this.defaultUsername = defaultUsername;
        this.defaultChannel = defaultChannel;
    }
}

