/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.check;

import io.theblackbox.commons.check.BaseThat;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import lombok.NonNull;

public class RuleThat<E>
extends BaseThat<Predicate<E>, RuleThat<E>> {
    RuleThat(Predicate<E> subject) {
        super(subject);
    }

    public RuleThat<E> appliesTo(@NonNull E subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        if (!((Predicate)this.subject()).test(subject)) {
            throw new IllegalArgumentException("Subject " + subject + " does not conform to " + this.subject());
        }
        return this;
    }

    @SafeVarargs
    public final RuleThat<E> appliesToAll(@NonNull E subject1, E ... subjects) {
        if (subject1 == null) {
            throw new NullPointerException("subject1");
        }
        this.appliesTo(subject1);
        Arrays.asList(subjects).stream().forEach(this::appliesTo);
        return this;
    }

    public final RuleThat<E> appliesToAll(@NonNull Collection<E> subjects) {
        if (subjects == null) {
            throw new NullPointerException("subjects");
        }
        subjects.stream().forEach(this::appliesTo);
        return this;
    }
}

