/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.check;

import io.theblackbox.commons.check.BooleanThat;
import io.theblackbox.commons.check.CollectionThat;
import io.theblackbox.commons.check.GenericThat;
import io.theblackbox.commons.check.IntegerThat;
import io.theblackbox.commons.check.RuleThat;
import java.util.Collection;
import java.util.function.Predicate;
import lombok.NonNull;

public class Check {
    private Check() {
    }

    public static <E> CollectionThat<E> thatCollectionOf(@NonNull Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        return new CollectionThat<E>(collection);
    }

    public static BooleanThat that(boolean booleanCondition) {
        return new BooleanThat(booleanCondition);
    }

    public static void thatIsFalse(boolean booleanCondition) {
        new BooleanThat(booleanCondition).isFalse();
    }

    public static void thatIsTrue(boolean booleanCondition) {
        new BooleanThat(booleanCondition).isTrue();
    }

    public static IntegerThat that(long number) {
        return new IntegerThat(number);
    }

    public static <E> GenericThat<E> that(@NonNull E object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        return new GenericThat<E>(object);
    }

    public static <E> RuleThat<E> thatRule(@NonNull Predicate<E> rule) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return new RuleThat<E>(rule);
    }
}

