/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.check;

import io.theblackbox.commons.check.AbstractThat;
import io.theblackbox.commons.check.BooleanThat;
import io.theblackbox.commons.check.Check;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class BaseThat<E, T extends BaseThat<E, T>>
extends AbstractThat<E, T> {
    BaseThat(E subject) {
        super(subject);
    }

    public BooleanThat on(@NonNull Predicate<E> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return Check.that(predicate.test(this.subject()));
    }

    T conformsTo(@NonNull Predicate<E> rule, String checkNameOverride, Optional<Supplier<String>> message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return (T)((BaseThat)this.evaluate(() -> rule.test(this.subject()), checkNameOverride, message));
    }

    T conformsTo(@NonNull Predicate<E> rule, Optional<Supplier<String>> message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.conformsTo(rule, "conformsTo", message);
    }

    public T conformsTo(@NonNull Predicate<E> rule, Supplier<String> message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.conformsTo(rule, Optional.of(message));
    }

    public T conformsTo(@NonNull Predicate<E> rule, String message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.conformsTo(rule, () -> message);
    }

    public T conformsTo(@NonNull Predicate<E> rule) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.conformsTo(rule, Optional.empty());
    }

    T doesNotConformsTo(@NonNull Predicate<E> rule, Optional<Supplier<String>> message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.conformsTo(s -> !rule.test(s), "doesNotConformsTo", message);
    }

    public T doesNotConformsTo(@NonNull Predicate<E> rule, Supplier<String> message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.doesNotConformsTo(rule, Optional.of(message));
    }

    public T doesNotConformsTo(@NonNull Predicate<E> rule, String message) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.doesNotConformsTo(rule, () -> message);
    }

    public T doesNotConformsTo(@NonNull Predicate<E> rule) {
        if (rule == null) {
            throw new NullPointerException("rule");
        }
        return this.doesNotConformsTo(rule, Optional.empty());
    }

    T equalsTo(@NonNull E other, Optional<Supplier<String>> message) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.conformsTo(other::equals, "equalsTo", message);
    }

    public T equalsTo(@NonNull E other, Supplier<String> message) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.equalsTo(other, Optional.of(message));
    }

    public T equalsTo(@NonNull E other, String message) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.equalsTo(other, Optional.of(() -> message));
    }

    public T equalsTo(@NonNull E other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.equalsTo(other, Optional.empty());
    }

    T notEqualsTo(@NonNull E other, Optional<Supplier<String>> message) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.conformsTo(s -> !other.equals(s), "notEqualsTo", message);
    }

    public T notEqualsTo(@NonNull E other, Supplier<String> message) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.notEqualsTo(other, Optional.of(message));
    }

    public T notEqualsTo(@NonNull E other, String message) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.notEqualsTo(other, Optional.of(() -> message));
    }

    public T notEqualsTo(@NonNull E other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.notEqualsTo(other, Optional.empty());
    }
}

