/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.check;

import io.theblackbox.commons.check.BaseThat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;

public class CollectionThat<E>
extends BaseThat<Collection<? extends E>, CollectionThat<E>> {
    public CollectionThat(Collection<? extends E> subject) {
        super(subject);
    }

    public CollectionThat<E> isNotEmpty(Optional<Supplier<String>> message) {
        return (CollectionThat)this.evaluate(() -> !((Collection)this.subject()).isEmpty(), "isNotEmpty", message);
    }

    public CollectionThat<E> isNotEmpty(Supplier<String> message) {
        return this.isNotEmpty(Optional.of(message));
    }

    public CollectionThat<E> isNotEmpty(String message) {
        return this.isNotEmpty(() -> message);
    }

    public CollectionThat<E> isNotEmpty() {
        return this.isNotEmpty(Optional.empty());
    }

    public CollectionThat<E> isEmpty(Optional<Supplier<String>> message) {
        return (CollectionThat)this.evaluate(() -> ((Collection)this.subject()).isEmpty(), "isEmpty", message);
    }

    public CollectionThat<E> isEmpty(Supplier<String> message) {
        return this.isEmpty(Optional.of(message));
    }

    public CollectionThat<E> isEmpty(String message) {
        return this.isEmpty(() -> message);
    }

    public CollectionThat<E> isEmpty() {
        return this.isEmpty(Optional.empty());
    }

    public CollectionThat<E> hasSize(int size, Optional<Supplier<String>> message) {
        return (CollectionThat)this.evaluate(() -> ((Collection)this.subject()).size() == size, "hasSize", message);
    }

    public CollectionThat<E> hasSize(int size, Supplier<String> message) {
        return this.hasSize(size, Optional.of(message));
    }

    public CollectionThat<E> hasSize(int size, String message) {
        return this.hasSize(size, () -> message);
    }

    public CollectionThat<E> hasSize(int size) {
        return this.hasSize(size, Optional.empty());
    }

    public CollectionThat<E> contains(E element, Optional<Supplier<String>> message) {
        return (CollectionThat)this.evaluate(() -> ((Collection)this.subject()).contains(element), "contains", message);
    }

    public CollectionThat<E> contains(E element, Supplier<String> message) {
        return this.contains(element, Optional.of(message));
    }

    public CollectionThat<E> contains(E element, String message) {
        return this.contains(element, () -> message);
    }

    public CollectionThat<E> contains(E element) {
        return this.contains(element, Optional.empty());
    }

    public CollectionThat<E> containsAll(Collection<E> elements, Optional<Supplier<String>> message) {
        return (CollectionThat)this.evaluate(() -> ((Collection)this.subject()).containsAll(elements), "containsAll", message);
    }

    public CollectionThat<E> containsAll(Collection<E> elements, Supplier<String> message) {
        return this.containsAll(elements, Optional.of(message));
    }

    public CollectionThat<E> containsAll(Collection<E> elements, String message) {
        return this.containsAll(elements, () -> message);
    }

    public CollectionThat<E> containsAll(Collection<E> elements) {
        return this.containsAll(elements, Optional.empty());
    }

    @SafeVarargs
    public final CollectionThat<E> containsAll(E ... elements) {
        return this.containsAll((Collection<E>)Arrays.asList(elements), Optional.empty());
    }

    public CollectionThat<E> isContainedBy(Collection<E> elements, Optional<Supplier<String>> message) {
        return (CollectionThat)this.evaluate(() -> elements.containsAll((Collection)this.subject()), "isContainedBy", message);
    }

    public CollectionThat<E> isContainedBy(Collection<E> elements, Supplier<String> message) {
        return this.isContainedBy(elements, Optional.of(message));
    }

    public CollectionThat<E> isContainedBy(Collection<E> elements, String message) {
        return this.isContainedBy(elements, () -> message);
    }

    public CollectionThat<E> isContainedBy(Collection<E> elements) {
        return this.isContainedBy(elements, Optional.empty());
    }

    @SafeVarargs
    public final CollectionThat<E> isContainedBy(E ... elements) {
        return this.isContainedBy((Collection<E>)Arrays.asList(elements), Optional.empty());
    }
}

