/*
 * Decompiled with CFR 0.152.
 */
package io.theblackbox.commons.check;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractThat<E, T extends AbstractThat<E, T>> {
    private final E subject;

    AbstractThat(E subject) {
        if (subject == null) {
            throw new NullPointerException("Subject to check is null");
        }
        this.subject = subject;
    }

    protected E subject() {
        return this.subject;
    }

    protected T evaluate(Supplier<Boolean> conditionToCheck, String checkName, Optional<Supplier<String>> message) {
        return this.evaluate(conditionToCheck, IllegalArgumentException::new, checkName, message);
    }

    protected T evaluate(Supplier<Boolean> conditionToCheck, String checkName, Supplier<String> message) {
        return this.evaluate(conditionToCheck, IllegalArgumentException::new, checkName, Optional.of(message));
    }

    protected T evaluate(Supplier<Boolean> conditionToCheck, String checkName) {
        return this.evaluate(conditionToCheck, IllegalArgumentException::new, checkName, Optional.empty());
    }

    protected T evaluate(Supplier<Boolean> conditionToCheck, Function<String, ? extends RuntimeException> exceptionFactory, String checkName, Optional<Supplier<String>> message) {
        if (!conditionToCheck.get().booleanValue()) {
            String exceptionMessage = "Check \"" + checkName + "\" failed on subject \"" + String.valueOf(this.subject()) + "\"" + message.map(m -> " with message: " + m).orElse("");
            throw exceptionFactory.apply(exceptionMessage);
        }
        return (T)this;
    }

    protected T evaluate(Supplier<Boolean> conditionToCheck, Function<String, ? extends RuntimeException> exceptionFactory, String checkName, Supplier<String> message) {
        return this.evaluate(conditionToCheck, exceptionFactory, checkName, Optional.of(message));
    }

    protected T evaluate(Supplier<Boolean> conditionToCheck, Function<String, ? extends RuntimeException> exceptionFactory, String checkName) {
        return this.evaluate(conditionToCheck, exceptionFactory, checkName, Optional.empty());
    }
}

