/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest;

import io.testproject.sdk.internal.exceptions.FailedReportException;
import io.testproject.sdk.internal.rest.ReportsQueue;
import io.testproject.sdk.internal.rest.messages.Report;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsQueueBatch
extends ReportsQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ReportsQueueBatch.class);
    private final URL remoteAddress;
    private static final int MAX_REPORTS_BATCH_SIZE = 10;
    private static final String TP_MAX_BATCH_SIZE_VARIABLE_NAME = "TP_MAX_REPORTS_BATCH_SIZE";
    private final int maxBatchSize;

    ReportsQueueBatch(CloseableHttpClient httpClient, String sessionId, URL remoteAddress) {
        super(httpClient, sessionId);
        int maxBatchSizeValueToSet;
        this.remoteAddress = remoteAddress;
        try {
            String tpMaxBatchSizeEnvVarValue = System.getenv(TP_MAX_BATCH_SIZE_VARIABLE_NAME);
            maxBatchSizeValueToSet = tpMaxBatchSizeEnvVarValue != null ? Integer.parseInt(tpMaxBatchSizeEnvVarValue) : 10;
        }
        catch (SecurityException e) {
            LOG.warn("Failed to retrieve the value of environment variable {}. Maximum reports batch size is set to the default value: {}.", new Object[]{TP_MAX_BATCH_SIZE_VARIABLE_NAME, 10, e});
            maxBatchSizeValueToSet = 10;
        }
        catch (Exception e) {
            LOG.warn("Failed to convert the value of environment variable {}. Maximum reports batch size is set to the default value: {}.", new Object[]{TP_MAX_BATCH_SIZE_VARIABLE_NAME, 10, e});
            maxBatchSizeValueToSet = 10;
        }
        this.maxBatchSize = maxBatchSizeValueToSet;
    }

    @Override
    void handleReport() throws InterruptedException, FailedReportException {
        LinkedList<Report> batchReports = new LinkedList<Report>();
        while (!this.getQueue().isEmpty() && batchReports.size() < this.maxBatchSize) {
            ReportsQueue.QueueItem item = this.getQueue().poll();
            if (null == item || item.getReport() == null) continue;
            batchReports.add(item.getReport());
        }
        if (batchReports.isEmpty()) {
            return;
        }
        String json = null;
        try {
            json = GSON.toJson(batchReports);
        }
        catch (Exception e) {
            LOG.error("Failed to create json from list: [{}]", batchReports, (Object)e);
            return;
        }
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/batch");
        httpPost.setEntity((HttpEntity)entity);
        this.sendReport(httpPost);
    }
}

