/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.testproject.sdk.internal.exceptions.FailedReportException;
import io.testproject.sdk.internal.rest.messages.Report;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsQueue
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportsQueue.class);
    protected static final Gson GSON = new GsonBuilder().create();
    private static final int PROGRESS_REPORT_DELAY = 3;
    protected static final int MAX_REPORT_FAILURE_ATTEMPTS = 4;
    private final LinkedBlockingQueue<QueueItem> queue = new LinkedBlockingQueue(10240);
    private final CloseableHttpClient httpClient;
    private final String sessionId;
    private boolean running;
    private Future<?> progressFuture;
    private boolean stopReports = false;

    public ReportsQueue(CloseableHttpClient httpClient, String sessionId) {
        this.httpClient = httpClient;
        this.sessionId = sessionId;
    }

    protected LinkedBlockingQueue<QueueItem> getQueue() {
        return this.queue;
    }

    protected CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    void submit(HttpEntityEnclosingRequestBase request, Report report) {
        if (!this.stopReports) {
            this.queue.add(new QueueItem(request, report));
        }
    }

    void handleReport() throws InterruptedException, FailedReportException {
        QueueItem item = this.queue.take();
        if (item.getRequest() == null && item.getReport() == null) {
            if (this.running) {
                LOG.error("Empty report and request were submitted to the queue!");
            }
            return;
        }
        this.sendReport((HttpPost)item.getRequest());
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running || !this.queue.isEmpty()) {
            try {
                this.handleReport();
            }
            catch (InterruptedException e) {
                LOG.error("Reports queue was interrupted");
                break;
            }
            catch (FailedReportException e) {
                this.stopReports = true;
                LOG.warn("Reports are disabled due to multiple failed attempts of sending reports to the agent.");
            }
        }
        LOG.trace("Reports queue for session [{}] has been stopped.", (Object)this.sessionId);
        if (!this.queue.isEmpty()) {
            LOG.warn("There are {} unreported items in the queue", (Object)this.queue.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReport(HttpPost httpPost) throws FailedReportException {
        CloseableHttpResponse response = null;
        for (int reportAttemptsCount = 4; reportAttemptsCount > 0; --reportAttemptsCount) {
            try {
                response = this.getHttpClient().execute((HttpUriRequest)httpPost);
            }
            catch (IOException e) {
                LOG.error("Failed to submit report.", (Throwable)e);
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            if (response == null) continue;
            if (Response.Status.Family.familyOf((int)response.getStatusLine().getStatusCode()) == Response.Status.Family.SUCCESSFUL) {
                return;
            }
            LOG.warn("Agent responded with an unexpected status {} to report.", (Object)response.getStatusLine().getStatusCode());
            LOG.info("Failed to send a report to the Agent, {} attempts remaining...", (Object)(reportAttemptsCount - 1));
        }
        LOG.error("All {} attempts to send report have failed.", (Object)4);
        throw new FailedReportException("All 4 attempts to send report have failed.");
    }

    public void stop() {
        LOG.trace("Raising flag to stop reports queue for session [{}]", (Object)this.sessionId);
        this.running = false;
        this.queue.add(new QueueItem(null, null));
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        if (this.progressFuture == null) {
            this.progressFuture = scheduler.scheduleAtFixedRate(() -> {
                Thread.currentThread().setName("Queue-Progress-Report");
                LOG.info("There are [{}] outstanding reports that should be transmitted to the Agent before the process exits.", (Object)this.queue.size());
                if (this.queue.isEmpty()) {
                    LOG.trace("Reporting queue is empty, stopping progress report...");
                    this.progressFuture.cancel(true);
                    scheduler.shutdown();
                }
            }, 0L, 3L, TimeUnit.SECONDS);
        }
    }

    static class QueueItem {
        private final HttpEntityEnclosingRequestBase request;
        private final Report report;

        HttpEntityEnclosingRequestBase getRequest() {
            return this.request;
        }

        Report getReport() {
            return this.report;
        }

        QueueItem(HttpEntityEnclosingRequestBase request, Report report) {
            this.request = request;
            this.report = report;
        }
    }
}

