/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.addons;

import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.addons.ActionProxy;
import io.testproject.sdk.internal.addons.AddonsHelper;
import io.testproject.sdk.internal.addons.interfaces.GenericAction;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.messages.ActionExecutionResponse;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAddonsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AddonsHelper.class);
    private final AgentClient agentClient;
    private final ReportingDriver driver;

    public GenericAddonsHelper(ReportingDriver driver, AgentClient agentClient) {
        this.driver = driver;
        this.agentClient = agentClient;
    }

    public void run(GenericAction action) {
        action.run(this.driver.report());
    }

    public ActionProxy execute(ActionProxy action) {
        return this.execute(action, -1);
    }

    public ActionProxy execute(ActionProxy action, int timeout) {
        ActionExecutionResponse response = this.agentClient.executeProxy(action, timeout);
        if (response.getResultType() != ActionExecutionResponse.ExecutionResultType.Passed) {
            throw new WebDriverException(response.getMessage());
        }
        for (ActionExecutionResponse.ResultField field : response.getFields()) {
            Optional<Field> proxyField;
            if (!field.isOutput() || (proxyField = Arrays.stream(action.getClass().getDeclaredFields()).filter(m -> m.getName().equals(field.getName())).findFirst()).isEmpty()) continue;
            proxyField.get().setAccessible(true);
            try {
                proxyField.get().set(action, this.convertToType(proxyField.get().getType(), (String)field.getValue()));
            }
            catch (IllegalAccessException e) {
                LOG.error("Failed to set field [{}] value to [{}]", (Object)field.getName(), field.getValue());
            }
        }
        return action;
    }

    private Object convertToType(Class<?> clazz, String value) {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(value);
        }
        try {
            if (Byte.class == clazz || Byte.TYPE == clazz) {
                return Byte.parseByte(value);
            }
            if (Short.class == clazz || Short.TYPE == clazz) {
                return Short.parseShort(value);
            }
            if (Integer.class == clazz || Integer.TYPE == clazz) {
                return Integer.parseInt(value);
            }
            if (Long.class == clazz || Long.TYPE == clazz) {
                return Long.parseLong(value);
            }
            if (Float.class == clazz || Float.TYPE == clazz) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.class == clazz || Double.TYPE == clazz) {
                return Double.parseDouble(value);
            }
            return value;
        }
        catch (NumberFormatException e) {
            LOG.error("Error parsing {} to {}", new Object[]{value, clazz, e});
            throw new IllegalArgumentException(String.format("Could not parse %s to %s", value, clazz.toString()));
        }
    }
}

