/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.addons;

import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.addons.ActionProxy;
import io.testproject.sdk.internal.addons.GenericAddonsHelper;
import io.testproject.sdk.internal.addons.interfaces.Action;
import io.testproject.sdk.internal.addons.interfaces.ElementAction;
import io.testproject.sdk.internal.rest.AgentClient;
import java.lang.reflect.ParameterizedType;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.WebDriver;

public class AddonsHelper<D extends WebDriver>
extends GenericAddonsHelper {
    private final D driver;

    public AddonsHelper(D driver, AgentClient agentClient) {
        super((ReportingDriver)driver, agentClient);
        this.driver = driver;
    }

    public <T extends WebDriver> boolean run(Action<T> action) {
        this.validateAction(action.getClass());
        return action.run(this.driver);
    }

    public <T extends WebDriver> boolean run(ElementAction<T> action, By elementSearchCriteria) {
        this.validateAction(action.getClass());
        return action.run(this.driver, elementSearchCriteria);
    }

    private void validateAction(Class<?> actionClass) {
        ParameterizedType genericInterface = (ParameterizedType)actionClass.getGenericInterfaces()[0];
        String typeName = genericInterface.getActualTypeArguments()[0].getTypeName().replaceAll("\\<.*\\>", "");
        try {
            if (!Class.forName(typeName).isAssignableFrom(this.driver.getClass())) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            throw new InvalidArgumentException(String.format("Driver %s cannot run this action because its driver type must inherit from %s", this.driver.getClass().getName(), typeName), (Throwable)e);
        }
    }

    public ActionProxy execute(ActionProxy action, By by) {
        return this.execute(action, by, -1);
    }

    public ActionProxy execute(ActionProxy action, By by, int timeout) {
        action.getDescriptor().setBy(by);
        return this.execute(action, timeout);
    }
}

