/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.interfaces.parameterization;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.testng.annotations.DataProvider;

public class TestProjectParameterizer
implements ArgumentsProvider {
    private static final String DATA_PROVIDER_ENV = "TP_TEST_DATA_PROVIDER";

    @DataProvider(name="TestProject")
    public static Object[][] provideArguments() throws Exception {
        List<String[]> strings = TestProjectParameterizer.getCSVLines();
        return (Object[][])strings.toArray((T[])new Object[0][]);
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        List<String[]> strings = TestProjectParameterizer.getCSVLines();
        return strings.stream().map(Arguments::of);
    }

    private static List<String[]> getCSVLines() throws Exception {
        String dataProviderPath = System.getenv(DATA_PROVIDER_ENV);
        if (StringUtils.isEmpty((CharSequence)dataProviderPath)) {
            throw new IllegalArgumentException("No data provider was specified. Make sure this annotation is used for uploaded tests only.");
        }
        File dataProviderFile = new File(dataProviderPath);
        if (!dataProviderFile.exists()) {
            throw new IllegalArgumentException("No data provider was specified. Make sure this annotation is used for uploaded tests only.");
        }
        CSVParser parser = CSVParser.parse((File)dataProviderFile, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
        return parser.getRecords().stream().skip(1L).map(record -> {
            Iterator iterator = record.iterator();
            ArrayList recordValues = new ArrayList();
            iterator.forEachRemaining(recordValues::add);
            return recordValues.toArray(new String[0]);
        }).collect(Collectors.toList());
    }
}

