/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ActionRunner;
import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class RemoteWebDriver
extends org.openqa.selenium.remote.RemoteWebDriver
implements ReportingDriver,
ActionRunner<org.openqa.selenium.remote.RemoteWebDriver> {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public RemoteWebDriver(Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(Capabilities capabilities, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public RemoteWebDriver(Capabilities capabilities, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, reportType);
    }

    public RemoteWebDriver(Capabilities capabilities, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, null, null, disableReports, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(Capabilities capabilities, boolean disableReports, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, null, null, disableReports, reportType);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, null, false, reportType);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName, String jobName, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, jobName, false, reportType);
    }

    public RemoteWebDriver(String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, null, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, null, null, false, reportType);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, String projectName, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, null, false, reportType);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, String projectName, String jobName, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, jobName, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, null, null, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, null, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName, String jobName, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, jobName, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, null, null, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities, ReportType reportType, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, null, null, false, reportType, sessionSocketTimeout);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities, String projectName, String jobName, boolean disableReports, ReportType reportType) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, projectName, jobName, disableReports, reportType, null, null, 120000);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities, String projectName, String jobName, boolean disableReports, ReportType reportType, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, projectName, jobName, disableReports, reportType, null, null, sessionSocketTimeout);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, null, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, false, reportType);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities, String projectName, String jobName, boolean disableReports, ReportType reportType, String reportName, String reportPath, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        super(AgentClient.getClient(remoteAddress, token, capabilities, new ReportSettings(projectName, jobName, reportType, reportName, reportPath), disableReports, sessionSocketTimeout).getSession().getCapabilities());
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }
}

