/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ActionRunner;
import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class ChromeDriver
extends org.openqa.selenium.chrome.ChromeDriver
implements ReportingDriver,
ActionRunner<RemoteWebDriver> {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public ChromeDriver() throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, new ChromeOptions(), 120000);
    }

    public ChromeDriver(ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, new ChromeOptions(), reportType);
    }

    public ChromeDriver(ChromeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, 120000);
    }

    public ChromeDriver(ChromeOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, sessionSocketTimeout);
    }

    public ChromeDriver(ChromeOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, reportType);
    }

    public ChromeDriver(ChromeOptions options, boolean disableReports) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(ChromeOptions options, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports, reportType);
    }

    public ChromeDriver(ChromeOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(ChromeOptions options, String projectName, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public ChromeDriver(ChromeOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, reportType);
    }

    public ChromeDriver(ChromeOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(ChromeOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false, reportType);
    }

    public ChromeDriver(String token, ChromeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, 120000);
    }

    public ChromeDriver(String token, ChromeOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, sessionSocketTimeout);
    }

    public ChromeDriver(String token, ChromeOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, reportType);
    }

    public ChromeDriver(String token, ChromeOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(String token, ChromeOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false, reportType);
    }

    public ChromeDriver(String token, ChromeOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(String token, ChromeOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false, reportType);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, 120000);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, sessionSocketTimeout);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, reportType);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false, reportType);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(URL remoteAddress, ChromeOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false, reportType);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, reportType);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, null, false, reportType);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, false, reportType);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, disableReports, reportType, null, null, 120000);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, disableReports, reportType, null, null, sessionSocketTimeout);
    }

    public ChromeDriver(URL remoteAddress, String token, ChromeOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType, String reportName, String reportPath, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        super((ChromeDriverService)new FakeDriverService(), new ChromeOptions().merge(AgentClient.getClient(remoteAddress, token, (Capabilities)options, new ReportSettings(projectName, jobName, reportType, reportName, reportPath), disableReports, sessionSocketTimeout).getSession().getCapabilities()));
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }

    static class FakeDriverService
    extends ChromeDriverService {
        FakeDriverService() throws IOException {
            super(new File(""), 0, null, null);
        }
    }
}

