/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers;

import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.addons.GenericAddonsHelper;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.GenericCommandExecutor;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.DesiredCapabilities;

public final class GenericDriver
implements ReportingDriver {
    private static final String MIN_GENERIC_DRIVER_SUPPORTED_VERSION = "0.64.40";
    private final Reporter reporter;
    private ReportingCommandsExecutor reportingCommandExecutor;

    public GenericDriver() throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(false);
    }

    public GenericDriver(ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(false, reportType);
    }

    public GenericDriver(boolean disableReports) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, null, null, disableReports, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, null, null, disableReports, reportType);
    }

    public GenericDriver(String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(String projectName, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, projectName, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public GenericDriver(String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, projectName, null, false, reportType);
    }

    public GenericDriver(String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, projectName, jobName, false, reportType);
    }

    public GenericDriver(String token, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(String token, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, projectName, jobName, false, reportType);
    }

    public GenericDriver(URL remoteAddress) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(URL remoteAddress, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, reportType);
    }

    public GenericDriver(URL remoteAddress, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(URL remoteAddress, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, projectName, jobName, false, reportType);
    }

    public GenericDriver(URL remoteAddress, String token) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public GenericDriver(URL remoteAddress, String token, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, null, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public GenericDriver(URL remoteAddress, String token, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, null, null, false, reportType);
    }

    public GenericDriver(URL remoteAddress, String token, String projectName, String jobName, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, projectName, jobName, disableReports, reportType, null, null, 120000);
    }

    public GenericDriver(URL remoteAddress, String token, String projectName, String jobName, boolean disableReports, ReportType reportType, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, projectName, jobName, disableReports, reportType, null, null, sessionSocketTimeout);
    }

    public GenericDriver(URL remoteAddress, String token, String projectName, String jobName, boolean disableReports, ReportType reportType, String reportName, String reportPath, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("platformName", Platform.ANY);
        String version = AgentClient.getVersion(remoteAddress);
        if (new ComparableVersion(version).compareTo(new ComparableVersion(MIN_GENERIC_DRIVER_SUPPORTED_VERSION)) < 0) {
            StringBuilder message = new StringBuilder().append("Target Agent version").append(" [").append(version).append("] ").append("doesn't support Generic driver. ").append("Upgrade the Agent to the latest version and try again.");
            throw new AgentConnectException(message.toString());
        }
        AgentClient agentClient = AgentClient.getClient(remoteAddress, token, (Capabilities)capabilities, new ReportSettings(projectName, jobName, reportType, reportName, reportPath), disableReports, sessionSocketTimeout);
        this.reportingCommandExecutor = new GenericCommandExecutor(agentClient);
        this.reportingCommandExecutor.setReportsDisabled(disableReports);
        this.reporter = new Reporter(this, AgentClient.getClient((Capabilities)capabilities));
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }

    @Override
    public void stop() {
    }

    @Override
    public ReportingCommandsExecutor getReportingCommandExecutor() {
        return this.reportingCommandExecutor;
    }

    public void quit() {
        if (!this.reportingCommandExecutor.isReportsDisabled()) {
            Command command = new Command(null, "quit");
            this.reportingCommandExecutor.reportCommand(command, null);
        }
    }

    public GenericAddonsHelper addons() {
        return new GenericAddonsHelper(this, this.getReportingCommandExecutor().getAgentClient());
    }
}

