/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest;

import io.testproject.sdk.drivers.ReportType;
import java.util.Objects;

public class ReportSettings {
    private final String projectName;
    private final String jobName;
    private ReportType reportType;
    private String reportName;
    private String reportPath;

    public String getProjectName() {
        return this.projectName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public ReportSettings(String projectName, String jobName) {
        this.projectName = projectName;
        this.jobName = jobName;
        this.reportType = ReportType.CLOUD_AND_LOCAL;
    }

    public ReportSettings(String projectName, String jobName, ReportType reportType) {
        this.projectName = projectName;
        this.jobName = jobName;
        this.reportType = reportType;
    }

    public ReportSettings(String projectName, String jobName, ReportType reportType, String reportName, String reportPath) {
        this.projectName = projectName;
        this.jobName = jobName;
        this.reportType = reportType;
        this.reportName = reportName;
        this.reportPath = reportPath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ReportSettings that = (ReportSettings)object;
        return Objects.equals(this.projectName, that.projectName) && Objects.equals(this.jobName, that.jobName);
    }

    public int hashCode() {
        return Objects.hash(this.projectName, this.jobName);
    }
}

