/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.internal.addons.ActionProxy;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.DeviceNotConnectedException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.MissingBrowserException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.inferrers.GenericInferrer;
import io.testproject.sdk.internal.reporting.inferrers.InferrerFactory;
import io.testproject.sdk.internal.rest.AgentSession;
import io.testproject.sdk.internal.rest.ReportSettings;
import io.testproject.sdk.internal.rest.ReportsQueue;
import io.testproject.sdk.internal.rest.ReportsQueueBatch;
import io.testproject.sdk.internal.rest.messages.ActionExecutionResponse;
import io.testproject.sdk.internal.rest.messages.AgentStatusResponse;
import io.testproject.sdk.internal.rest.messages.DriverCommandReport;
import io.testproject.sdk.internal.rest.messages.SessionRequest;
import io.testproject.sdk.internal.rest.messages.SessionResponse;
import io.testproject.sdk.internal.rest.messages.StepReport;
import io.testproject.sdk.internal.rest.messages.TestReport;
import io.testproject.sdk.internal.rest.serialization.DriverExclusionStrategy;
import io.testproject.sdk.internal.tcp.SocketManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AgentClient
implements Closeable {
    public static final int NEW_SESSION_SOCKET_TIMEOUT_MS = 120000;
    public static final int REPORTS_QUEUE_TIMEOUT = 600;
    private static final String TP_GUID = "tp:guid";
    private static final String TP_AGENT_URL = "TP_AGENT_URL";
    private static final String TP_DEV_TOKEN = "TP_DEV_TOKEN";
    private static final String AGENT_DEFAULT_API_ADDRESS = "http://localhost:8585";
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final int CONNECTION_REQUEST_TIMEOUT_MS = 5000;
    private static final int ADDON_EXECUTION_SOCKET_TIMEOUT_MS = 60000;
    private static final String MIN_SESSION_REUSE_CAPABLE_VERSION = "0.64.32";
    private static final String MIN_LOCAL_REPORT_SUPPORTED_VERSION = "2.1.0";
    private static final Logger LOG = LoggerFactory.getLogger(AgentClient.class);
    private static AgentClient instance;
    private static String version;
    private static boolean isLocalExecution;
    private static final Gson GSON;
    private final ExecutorService reportsExecutorService = Executors.newSingleThreadExecutor();
    private final URL remoteAddress;
    private final String token;
    private final CloseableHttpClient httpClient;
    private Future<?> reportsQueueFuture;
    private ReportsQueue reportsQueue;
    private AgentSession session;
    private String projectName;
    private String jobName;
    private int sessionSocketTimeout;
    private static boolean warned;
    private boolean skipInferring = false;
    private boolean reportsDisabled = false;
    private SessionResponse agentResponse;
    private static final String MIN_BATCH_REPORT_SUPPORTED_VERSION = "3.1.0";

    private AgentClient(URL remoteAddress, String token, Capabilities capabilities, ReportSettings reportSettings, boolean disableReports, int sessionSocketTimeout) throws MalformedURLException, InvalidTokenException, AgentConnectException, ObsoleteVersionException {
        this.remoteAddress = AgentClient.inferRemoteAddress(remoteAddress);
        this.sessionSocketTimeout = sessionSocketTimeout;
        if (!StringUtils.isEmpty((CharSequence)System.getenv(TP_DEV_TOKEN))) {
            if (!StringUtils.isEmpty((CharSequence)token)) {
                LOG.info("Using {} parameter from environment", (Object)TP_DEV_TOKEN);
            }
            this.token = System.getenv(TP_DEV_TOKEN);
        } else if (!StringUtils.isEmpty((CharSequence)token)) {
            this.token = token;
        } else {
            throw new InvalidTokenException("No token has been provided.");
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().addInterceptorLast((request, context) -> {
            request.setHeader("Authorization", this.token);
            request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        });
        this.httpClient = httpClientBuilder.build();
        this.reportsDisabled = disableReports;
        ReportSettings sessionReportSettings = null;
        if (!disableReports) {
            if (Boolean.getBoolean("TP_DISABLE_AUTO_REPORTS")) {
                this.skipInferring = true;
            }
            if (reportSettings.getJobName() != null) {
                System.setProperty("TP_JOB_NAME_SET", "true");
            }
            sessionReportSettings = AgentClient.inferReportSettings(reportSettings);
        }
        try {
            this.startSession(capabilities, sessionReportSettings);
        }
        catch (MissingBrowserException e) {
            throw new AgentConnectException(String.format("Requested browser %s is not installed", capabilities.getBrowserName()), e);
        }
        catch (DeviceNotConnectedException e) {
            throw new AgentConnectException(String.format("Requested device %s is not connected", capabilities.getCapability("udid")), e);
        }
        this.verifyLocalReportsSupported(reportSettings.getReportType());
        if (!disableReports) {
            this.reportsQueue = new ComparableVersion(version).compareTo(new ComparableVersion(MIN_BATCH_REPORT_SUPPORTED_VERSION)) >= 0 ? new ReportsQueueBatch(this.httpClient, this.getSession().getSessionId(), this.remoteAddress) : new ReportsQueue(this.httpClient, this.getSession().getSessionId());
            this.reportsQueueFuture = this.reportsExecutorService.submit(this.reportsQueue);
        }
        ShutdownThreadManager.getInstance().addAgentClient(() -> this.close(true));
    }

    private static URL inferRemoteAddress(URL url) throws MalformedURLException {
        URL result;
        List<String> localHosts = Arrays.asList("127.0.0.1", "localhost", "0.0.0.0");
        if (localHosts.contains((result = url != null ? url : (!StringUtils.isEmpty((CharSequence)System.getenv(TP_AGENT_URL)) ? new URL(System.getenv(TP_AGENT_URL)) : new URL(AGENT_DEFAULT_API_ADDRESS))).getHost())) {
            isLocalExecution = true;
        }
        return result;
    }

    private static boolean canReuseSession() {
        if (version == null) {
            return false;
        }
        boolean result = false;
        try {
            ComparableVersion agentVersion = new ComparableVersion(version);
            result = agentVersion.compareTo(new ComparableVersion(MIN_SESSION_REUSE_CAPABLE_VERSION)) >= 0;
            LOG.trace("Agent [{}] {} session re-use", (Object)version, (Object)(result ? "supports" : "does not support"));
            return result;
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public static AgentClient getInstance() {
        if (instance == null && !warned) {
            warned = true;
        }
        return instance;
    }

    public static AgentClient getClient(Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, null, capabilities, null, false, 120000);
    }

    public static AgentClient getClient(Capabilities capabilities, ReportSettings reportSettings) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, null, capabilities, reportSettings, true, 120000);
    }

    public static AgentClient getClient(String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, token, capabilities, null, false, 120000);
    }

    public static AgentClient getClient(String token, Capabilities capabilities, ReportSettings reportSettings) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, token, capabilities, reportSettings, true, 120000);
    }

    public static AgentClient getClient(URL remoteAddress, Capabilities capabilities, ReportSettings reportSettings) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(remoteAddress, null, capabilities, reportSettings, true, 120000);
    }

    public static AgentClient getClient(URL remoteAddress, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(remoteAddress, null, capabilities, null, false, 120000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentClient getClient(URL remoteAddress, String token, Capabilities capabilities, ReportSettings reportSettings, boolean disableReports, int sessionSocketTimeout) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        if (!capabilities.asMap().containsKey(TP_GUID)) {
            MutableCapabilities newCapabilities = new MutableCapabilities();
            newCapabilities.setCapability(TP_GUID, UUID.randomUUID().toString());
            capabilities = capabilities.merge((Capabilities)newCapabilities);
        }
        Class<AgentClient> clazz = AgentClient.class;
        synchronized (AgentClient.class) {
            if (instance == null || !instance.getSession().getCapabilities().getCapability(TP_GUID).equals(capabilities.getCapability(TP_GUID))) {
                ReportSettings settings = reportSettings;
                if (instance != null) {
                    boolean sameReportSettings;
                    if (settings.getProjectName() == null || settings.getJobName() == null) {
                        settings = AgentClient.inferReportSettings(reportSettings);
                    }
                    boolean bl = sameReportSettings = instance.getReportSetting() != null && instance.getReportSetting().equals(settings);
                    if (!(sameReportSettings && AgentClient.canReuseSession() || Boolean.getBoolean("TP_FORCE_SESSION_REUSE"))) {
                        System.setProperty("TP_JOB_NAME_SET", "false");
                        SocketManager.getInstance().closeSocket();
                    }
                    instance.stop();
                }
                instance = new AgentClient(remoteAddress, token, capabilities, settings, disableReports, sessionSocketTimeout);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return instance;
        }
    }

    public static String getVersion(URL remoteAddress) throws AgentConnectException, MalformedURLException {
        String responseBody;
        CloseableHttpResponse response;
        URL agentAddress = AgentClient.inferRemoteAddress(remoteAddress);
        HttpGet httpGet = new HttpGet(agentAddress + "/api/status");
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
        httpGet.setConfig(config);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().addInterceptorLast((request, context) -> {
            request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        });
        try {
            response = httpClientBuilder.build().execute((HttpUriRequest)httpGet);
        }
        catch (IOException e) {
            LOG.error("Failed to get Agent status", (Throwable)e);
            throw new AgentConnectException("Failed to get Agent status", e);
        }
        if (response != null && response.getStatusLine().getStatusCode() != 200) {
            LOG.error("Agent responded with an unexpected status {} to status request", (Object)response.getStatusLine().getStatusCode());
        }
        if (response == null) {
            LOG.error("Agent response is empty");
            throw new AgentConnectException("Failed to get Agent status");
        }
        try {
            responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOG.error("Failed reading Agent status response", (Throwable)e);
            throw new AgentConnectException("Failed to get Agent status", e);
        }
        AgentStatusResponse status = null;
        try {
            status = (AgentStatusResponse)GSON.fromJson(responseBody, AgentStatusResponse.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Failed to parse Agent response", (Throwable)e);
            throw new AgentConnectException("Failed to parse Agent response", e);
        }
        return status.getTag();
    }

    private RequestConfig getDefaultHttpConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
    }

    private void startSession(Capabilities capabilities, ReportSettings reportSettings) throws InvalidTokenException, AgentConnectException, ObsoleteVersionException, MissingBrowserException, DeviceNotConnectedException {
        String responseBody;
        CloseableHttpResponse response;
        LOG.info("Initializing new session...");
        LOG.trace("Initializing new session with capabilities: {}", (Object)GSON.toJson((Object)capabilities));
        String guid = Objects.requireNonNull(capabilities.getCapability(TP_GUID)).toString();
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/session");
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(this.sessionSocketTimeout).build();
        httpPost.setConfig(config);
        SessionRequest request = new SessionRequest(reportSettings, capabilities.asMap());
        this.projectName = request.getProjectName();
        this.jobName = request.getJobName();
        StringEntity entity = new StringEntity(GSON.toJson((Object)request), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            throw this.translateAgentConnectFailure(e);
        }
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            this.handleSessionStartFailure(response, capabilities);
            return;
        }
        try {
            responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOG.error("Failed reading Agent response", (Throwable)e);
            throw new AgentConnectException("Failed reading Agent response", e);
        }
        LOG.trace("Session initialization response: {}", (Object)responseBody);
        try {
            this.agentResponse = (SessionResponse)GSON.fromJson(responseBody, SessionResponse.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Failed to parse Agent response", (Throwable)e);
            throw new AgentConnectException("Failed to parse Agent response", e);
        }
        LOG.info("Session [{}] initialized", (Object)this.agentResponse.getSessionId());
        try {
            MutableCapabilities mutableCapabilities = this.agentResponse.getCapabilities() != null ? new MutableCapabilities(this.agentResponse.getCapabilities()) : new MutableCapabilities();
            mutableCapabilities.setCapability(TP_GUID, guid);
            version = this.agentResponse.getVersion();
            URL serverUrl = capabilities.getPlatform() == Platform.ANY ? null : new URL(this.agentResponse.getServerAddress());
            List<String> warnings = this.agentResponse.getWarnings();
            if (warnings != null) {
                for (String warning : warnings) {
                    LOG.warn(warning);
                }
            }
            try {
                if (!StringUtils.isEmpty((CharSequence)this.agentResponse.getLocalReportUrl())) {
                    String reportUrl = new URIBuilder(this.agentResponse.getLocalReportUrl()).setHost(this.remoteAddress.getHost()).build().toString();
                    LOG.info("Report URL: " + reportUrl);
                }
            }
            catch (URISyntaxException e) {
                throw new AgentConnectException("Failed building URL from " + this.remoteAddress, e);
            }
            this.session = new AgentSession(serverUrl, !StringUtils.isEmpty((CharSequence)this.agentResponse.getSessionId()) ? this.agentResponse.getSessionId() : UUID.randomUUID().toString(), this.agentResponse.getDialect() != null ? Dialect.valueOf((String)this.agentResponse.getDialect()) : null, (Capabilities)mutableCapabilities);
        }
        catch (MalformedURLException e) {
            LOG.error("Agent returned an invalid server URL: [{}]", (Object)this.agentResponse.getServerAddress(), (Object)e);
            throw new AgentConnectException("Failed initializing a session", e);
        }
        SocketManager.getInstance().openSocket(this.remoteAddress.getHost(), this.agentResponse.getDevSocketPort(), this.agentResponse.getUuid());
    }

    private AgentConnectException translateAgentConnectFailure(IOException e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (SocketTimeoutException.class.isAssignableFrom(rootCause.getClass())) {
            return new AgentConnectException("Could not complete the request to start a new session. Another program such as an antivirus/firewall seems to be interfering with the connection.");
        }
        if (ConnectException.class.isAssignableFrom(rootCause.getClass())) {
            return new AgentConnectException("Could not connect to agent. Please make sure it is running and try again");
        }
        return new AgentConnectException("Failed communicating with the Agent at " + this.remoteAddress, e);
    }

    private static ReportSettings inferReportSettings(ReportSettings reportSettings) {
        if (reportSettings != null && !StringUtils.isEmpty((CharSequence)reportSettings.getProjectName()) && !StringUtils.isEmpty((CharSequence)reportSettings.getJobName())) {
            LOG.trace("Project and Job names were explicitly set, skipping inferring.");
            return reportSettings;
        }
        LOG.trace("Report settings were not provided or incomplete, trying to infer...");
        List<StackTraceElement> traces = Arrays.asList(Thread.currentThread().getStackTrace());
        ReportSettings inferredReportSettings = InferrerFactory.getInferrer(traces).inferReportSettings();
        if (inferredReportSettings == null) {
            inferredReportSettings = new GenericInferrer(traces).inferReportSettings();
        }
        LOG.info("Inferred [{}] and [{}] for Project and Job names accordingly.", (Object)inferredReportSettings.getProjectName(), (Object)inferredReportSettings.getJobName());
        ReportSettings result = reportSettings != null ? new ReportSettings(!StringUtils.isEmpty((CharSequence)reportSettings.getProjectName()) ? reportSettings.getProjectName() : inferredReportSettings.getProjectName(), !StringUtils.isEmpty((CharSequence)reportSettings.getJobName()) ? reportSettings.getJobName() : inferredReportSettings.getJobName(), reportSettings.getReportType(), reportSettings.getReportName(), reportSettings.getReportPath()) : inferredReportSettings;
        LOG.info("Using [{}] and [{}] for Project and Job names accordingly.", (Object)result.getProjectName(), (Object)result.getJobName());
        return result;
    }

    private void verifyLocalReportsSupported(ReportType reportType) throws AgentConnectException {
        if (reportType == ReportType.LOCAL && new ComparableVersion(version).compareTo(new ComparableVersion(MIN_LOCAL_REPORT_SUPPORTED_VERSION)) < 0) {
            StringBuilder message = new StringBuilder().append("Target Agent version").append(" [").append(version).append("] ").append("doesn't support local reports. ").append("Upgrade the Agent to the latest version and try again.");
            throw new AgentConnectException(message.toString());
        }
    }

    private void handleSessionStartFailure(CloseableHttpResponse response, Capabilities capabilities) throws InvalidTokenException, ObsoleteVersionException, AgentConnectException, MissingBrowserException, DeviceNotConnectedException {
        String statusMessage = null;
        try {
            String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
            JsonObject json = (JsonObject)new JsonParser().parse(responseBody);
            JsonElement message = json.get("message");
            statusMessage = message != null && !message.isJsonNull() ? message.getAsString() : null;
        }
        catch (IOException e) {
            LOG.error("Failed reading Agent response", (Throwable)e);
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                LOG.error("Failed to initialize a session with the Agent - token is invalid");
                throw new InvalidTokenException();
            }
            case 404: 
            case 406: {
                LOG.error("Failed to initialize a session with the Agent");
                throw new AgentConnectException(statusMessage);
            }
        }
        LOG.error("Failed to initialize a session with the Agent");
        throw new AgentConnectException("Agent responded with status " + response.getStatusLine().getStatusCode() + ": [" + statusMessage + "]");
    }

    public AgentSession getSession() {
        return this.session;
    }

    public String getVersion() {
        return version;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public ReportSettings getReportSetting() {
        if (StringUtils.isEmpty((CharSequence)this.projectName) || StringUtils.isEmpty((CharSequence)this.jobName)) {
            return null;
        }
        return new ReportSettings(this.projectName, this.jobName);
    }

    public boolean getSkipInferring() {
        return this.skipInferring;
    }

    public boolean getReportsDisabled() {
        return this.reportsDisabled;
    }

    public static boolean isWarned() {
        return warned;
    }

    private void stop() {
        ShutdownThreadManager.getInstance().removeAgentClient();
        LOG.trace("Removed shutdown thread to avoid unnecessary close() calls");
        this.close();
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean exiting) {
        LOG.trace("Closing AgentClient for driver session [{}]", (Object)this.getSession().getSessionId());
        if (this.reportsQueueFuture != null && !this.reportsQueueFuture.isDone()) {
            this.reportsQueue.stop();
            try {
                this.reportsQueueFuture.get(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("Reports queue was interrupted while sending reports.");
            }
            catch (ExecutionException e) {
                LOG.error("Reports queue has thrown an exception", ExceptionUtils.getRootCause((Throwable)e));
            }
            catch (TimeoutException e) {
                LOG.error("Reports queue didn't finish uploading reports in a timely manner and was terminated.");
            }
            if (!this.reportsQueueFuture.isDone()) {
                LOG.warn("Terminating reports queue forcibly...");
                this.reportsQueueFuture.cancel(true);
            }
        }
        if (!this.reportsExecutorService.isTerminated()) {
            this.reportsExecutorService.shutdown();
        }
        if (exiting) {
            LOG.debug("Agent client is closing development socket as process is exiting...");
            SocketManager.getInstance().closeSocket();
        }
        LOG.info("Session [{}] closed", (Object)this.getSession().getSessionId());
        if (!StringUtils.isEmpty((CharSequence)this.agentResponse.getLocalReport()) && isLocalExecution) {
            LOG.info("Execution Report: {}", (Object)this.agentResponse.getLocalReport());
        }
    }

    public boolean reportCommand(Command command, Object result, boolean passed, String screenshot) {
        String json;
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/command");
        httpPost.setConfig(this.getDefaultHttpConfig());
        DriverCommandReport report = new DriverCommandReport(command.getName(), command.getParameters(), result, passed);
        if (screenshot != null) {
            report.setScreenshot(screenshot);
        }
        try {
            json = GSON.toJson((Object)report);
        }
        catch (Exception e) {
            return false;
        }
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        this.reportsQueue.submit((HttpEntityEnclosingRequestBase)httpPost, report);
        return true;
    }

    public boolean reportStep(StepReport report) {
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/step");
        httpPost.setConfig(this.getDefaultHttpConfig());
        StringEntity entity = new StringEntity(GSON.toJson((Object)report), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        this.reportsQueue.submit((HttpEntityEnclosingRequestBase)httpPost, report);
        return true;
    }

    public boolean reportTest(TestReport report) {
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/test");
        httpPost.setConfig(this.getDefaultHttpConfig());
        StringEntity entity = new StringEntity(GSON.toJson((Object)report), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        this.reportsQueue.submit((HttpEntityEnclosingRequestBase)httpPost, report);
        return true;
    }

    public ActionExecutionResponse executeProxy(ActionProxy action, int timeout) throws WebDriverException {
        String responseBody;
        CloseableHttpResponse response;
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/addons/executions");
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(timeout > 0 ? timeout : 60000).build();
        httpPost.setConfig(config);
        HashMap parameters = (HashMap)GSON.fromJson(GSON.toJsonTree((Object)action).toString(), HashMap.class);
        action.getDescriptor().setParameters(parameters);
        String request = GSON.toJson((Object)action.getDescriptor());
        LOG.trace("Sending action proxy request: {}", (Object)request);
        StringEntity entity = new StringEntity(request, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            LOG.error("Failed to execute action proxy: [{}]", (Object)action, (Object)e);
            throw new WebDriverException("Failed to execute action proxy: [" + action + "]", (Throwable)e);
        }
        if (response != null && response.getStatusLine().getStatusCode() != 200) {
            LOG.error("Agent responded with an unexpected status {} to action proxy execution: [{}]", (Object)response.getStatusLine().getStatusCode(), (Object)action);
        }
        if (response == null) {
            LOG.error("Agent response is empty");
            throw new WebDriverException("Failed to execute action proxy: [" + action + "]");
        }
        try {
            responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOG.error("Failed reading action proxy execution response", (Throwable)e);
            throw new WebDriverException("Failed reading action proxy execution response", (Throwable)e);
        }
        try {
            return (ActionExecutionResponse)GSON.fromJson(responseBody, ActionExecutionResponse.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Failed reading action proxy execution response", (Throwable)e);
            throw new WebDriverException("Failed reading action proxy execution response", (Throwable)e);
        }
    }

    public void updateJobName(String updatedJobName) {
        CloseableHttpResponse response;
        HttpPut httpPut = new HttpPut(this.remoteAddress + "/api/development/session");
        httpPut.setConfig(this.getDefaultHttpConfig());
        SessionRequest request = new SessionRequest(updatedJobName);
        String data = GSON.toJson((Object)request);
        LOG.trace("Sending request to update job name to: {}", (Object)data);
        StringEntity entity = new StringEntity(data, StandardCharsets.UTF_8);
        httpPut.setEntity((HttpEntity)entity);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPut);
        }
        catch (IOException e) {
            LOG.error("Failed to execute request to update job name: [{}]", (Object)updatedJobName, (Object)e);
            return;
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            LOG.error("Failed to update job name to {}", (Object)updatedJobName);
        }
    }

    static {
        GSON = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new DriverExclusionStrategy()}).create();
        warned = false;
    }

    static class Routes {
        static final String STATUS = "/api/status";
        static final String DEVELOPMENT_SESSION = "/api/development/session";
        static final String REPORT_COMMAND = "/api/development/report/command";
        static final String REPORT_STEP = "/api/development/report/step";
        static final String REPORT_TEST = "/api/development/report/test";
        static final String REPORT_BATCH = "/api/development/report/batch";
        static final String EXECUTE_ACTION_PROXY = "/api/addons/executions";

        Routes() {
        }
    }
}

