/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.helpers;

import io.testproject.sdk.internal.helpers.CustomAppiumCommandExecutor;
import io.testproject.sdk.internal.helpers.CustomHttpCommandExecutor;
import io.testproject.sdk.internal.rest.AgentClient;
import java.lang.reflect.Field;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;

public final class DriverHelper {
    static final String FIELD_CAPABILITIES = "capabilities";
    static final String FIELD_RESPONSE_CODEC = "responseCodec";
    static final String FIELD_COMMAND_CODEC = "commandCodec";

    private DriverHelper() {
    }

    private static Field getPrivateField(Class<?> clazz, String fieldName) {
        NoSuchFieldException recentException = null;
        for (Class<?> superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            try {
                return superclass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                recentException = e;
                continue;
            }
        }
        throw new WebDriverException(recentException);
    }

    static void setPrivateFieldValue(Object object, String fieldName, Object value) {
        try {
            Field field = DriverHelper.getPrivateField(object.getClass(), fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static void setCapabilities(WebDriver driver, Capabilities capabilities) {
        try {
            Field capabilitiesField = RemoteWebDriver.class.getDeclaredField(FIELD_CAPABILITIES);
            capabilitiesField.setAccessible(true);
            capabilitiesField.set(driver, capabilities);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static HttpCommandExecutor getHttpCommandExecutor(AgentClient agentClient, boolean appium) {
        if (appium) {
            return new CustomAppiumCommandExecutor(agentClient, agentClient.getSession().getRemoteAddress());
        }
        return new CustomHttpCommandExecutor(agentClient, agentClient.getSession().getRemoteAddress());
    }
}

