/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class InternetExplorerDriver
extends org.openqa.selenium.ie.InternetExplorerDriver
implements ReportingDriver {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));
    private static final Logger LOG = LoggerFactory.getLogger(InternetExplorerDriver.class);

    public InternetExplorerDriver() throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, new InternetExplorerOptions());
    }

    public InternetExplorerDriver(ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, new InternetExplorerOptions());
    }

    public InternetExplorerDriver(InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, sessionSocketTimeout);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, reportType);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, boolean disableReports) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports, reportType);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, reportType);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false, reportType);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, null, null, false, reportType);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false, reportType);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL, sessionSocketTimeout);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, disableReports, reportType, null, null, 120000);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, disableReports, reportType, null, null, sessionSocketTimeout);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, null, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, false, reportType);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType, String reportName, String reportPath, int sessionSocketTimeout) throws InvalidTokenException, AgentConnectException, ObsoleteVersionException, MalformedURLException {
        super(InternetExplorerDriver.fakeDriverService(), new InternetExplorerOptions().merge(AgentClient.getClient(remoteAddress, token, (Capabilities)options, new ReportSettings(projectName, jobName, reportType, reportName, reportPath), disableReports, sessionSocketTimeout).getSession().getCapabilities()));
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }

    private static InternetExplorerDriverService fakeDriverService() {
        try {
            Constructor serviceConstructor = InternetExplorerDriverService.class.getDeclaredConstructor(File.class, Integer.TYPE, ImmutableList.class, ImmutableMap.class);
            serviceConstructor.setAccessible(true);
            return (InternetExplorerDriverService)serviceConstructor.newInstance(new File(""), 0, null, null);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Failed to create driver service", (Throwable)e);
            throw new WebDriverException("Failed creating Internet Explorer driver service while initializing driver", (Throwable)e);
        }
    }
}

