/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.tcp;

import io.testproject.sdk.internal.exceptions.AgentConnectException;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.util.Strings;

public final class SocketManager {
    private static final int TIMEOUT_MILLISECONDS = 5000;
    public static final int CONNECTION_SLEEP_TIME = 100;
    private static SocketManager instance;
    private static final Logger LOG;
    private Socket socket;
    private static final int SOCKET_VALIDATION_TIMEOUT = 30000;

    private SocketManager() {
    }

    public static SocketManager getInstance() {
        if (instance == null) {
            instance = new SocketManager();
        }
        return instance;
    }

    public void closeSocket() {
        if (this.isOpen()) {
            LOG.debug("Disconnecting TCP development socket...");
            try {
                this.socket.close();
                this.socket = null;
                LOG.debug("Development socket closed");
            }
            catch (IOException e) {
                LOG.error("Failed closing development socket connected to the Agent", (Throwable)e);
            }
        }
    }

    public void openSocket(String host, int port, String uuid) throws AgentConnectException {
        if (this.socket != null && this.socket.isConnected()) {
            LOG.debug("Development socket is already connected.");
            return;
        }
        try {
            LOG.trace("Connecting to Agent socket: {}:{}", (Object)host, (Object)port);
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(host, port), 5000);
            if (Strings.isNotNullAndNotEmpty((String)uuid)) {
                LOG.trace("Validating connection to the Agent...");
                boolean connected = false;
                long startTime = System.currentTimeMillis();
                long endTime = startTime + 30000L;
                DataInputStream inputStream = new DataInputStream(this.socket.getInputStream());
                while (System.currentTimeMillis() < endTime) {
                    if (inputStream.available() > 2) {
                        String message = inputStream.readUTF();
                        if (!StringUtils.equals((CharSequence)message, (CharSequence)uuid)) break;
                        connected = true;
                        break;
                    }
                    Thread.sleep(100L);
                }
                if (!connected) {
                    throw new AgentConnectException("SDK failed to connect to the Agent via a TCP socket on port " + port + "\nPlease check if you have any interfering software installed, and disable it.");
                }
            }
            LOG.debug("Development socket connected");
        }
        catch (IOException | InterruptedException e) {
            LOG.error("Failed connecting to Agent socket at {}:{}", new Object[]{host, port, e});
            throw new AgentConnectException("Failed connecting to Agent socket", e);
        }
    }

    public boolean isOpen() {
        return this.socket != null && this.socket.isConnected();
    }

    static {
        LOG = LoggerFactory.getLogger(SocketManager.class);
    }
}

