/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest.messages;

import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionRequest {
    private final Map<String, Object> capabilities;
    private String sdkVersion;
    private final String language = "Java";
    private String projectName;
    private String jobName;
    private ReportType reportType;
    private String reportName;
    private String reportPath;

    public SessionRequest(ReportSettings reportSettings, Map<String, Object> capabilities) {
        if (reportSettings != null) {
            this.projectName = reportSettings.getProjectName();
            this.jobName = reportSettings.getJobName();
            this.reportType = reportSettings.getReportType();
            this.reportName = reportSettings.getReportName();
            this.reportPath = reportSettings.getReportPath();
        }
        this.sdkVersion = this.getClass().getPackage().getImplementationVersion();
        if (this.sdkVersion != null && this.sdkVersion.contains("-")) {
            this.sanitizeVersion();
        }
        if (StringUtils.isEmpty((CharSequence)this.sdkVersion)) {
            String debugVersion = System.getenv("TP_DEBUG_SDK_VERSION");
            Logger log = LoggerFactory.getLogger(SessionRequest.class);
            log.debug("Using value [{}] from TP_DEBUG_SDK_VERSION environment variable", (Object)debugVersion);
            this.sdkVersion = debugVersion;
        }
        this.capabilities = capabilities;
    }

    private void sanitizeVersion() {
        this.sdkVersion = this.sdkVersion.split("-")[0];
    }

    public SessionRequest(String jobName) {
        this.jobName = jobName;
        this.capabilities = new HashMap<String, Object>();
    }

    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getLanguage() {
        return "Java";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public ReportType getReportType() {
        return this.reportType;
    }
}

