/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.testproject.sdk.internal.rest.messages.Report;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsQueue
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportsQueue.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final ArrayBlockingQueue<QueueItem> queue = new ArrayBlockingQueue(0x100000);
    private final CloseableHttpClient httpClient;
    private final String sessionId;
    private boolean running;
    private Future<?> progressFuture;
    private static final int PROGRESS_REPORT_DELAY = 3;

    public ReportsQueue(CloseableHttpClient httpClient, String sessionId) {
        this.httpClient = httpClient;
        this.sessionId = sessionId;
    }

    void submit(HttpEntityEnclosingRequestBase request, Report report) {
        this.queue.add(new QueueItem(request, report));
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running || this.queue.size() > 0) {
            try {
                this.sendReport(this.queue.take());
            }
            catch (InterruptedException e) {
                LOG.error("Reports queue was interrupted");
                break;
            }
        }
        LOG.trace("Reports queue for session [{}] has been stopped.", (Object)this.sessionId);
        if (!this.queue.isEmpty()) {
            LOG.warn("There are {} unreported items in the queue", (Object)this.queue.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReport(QueueItem item) {
        if (item.getRequest() == null && item.getReport() == null) {
            if (this.running) {
                LOG.error("Empty report and request were submitted to the queue!");
            }
            return;
        }
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)item.getRequest());
        }
        catch (IOException e) {
            LOG.error("Failed to submit report: [{}]", (Object)item.getReport(), (Object)e);
            return;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        if (response != null && response.getStatusLine().getStatusCode() != 200) {
            LOG.error("Agent responded with an unexpected status {} to report: [{}]", (Object)response.getStatusLine().getStatusCode(), (Object)item.getReport());
        }
    }

    public void stop() {
        LOG.trace("Raising flag to stop reports queue for session [{}]", (Object)this.sessionId);
        this.running = false;
        this.queue.add(new QueueItem(null, null));
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        if (this.progressFuture == null) {
            this.progressFuture = scheduler.scheduleAtFixedRate(() -> {
                Thread.currentThread().setName("Queue-Progress-Report");
                LOG.info("There are [{}] outstanding reports that should be transmitted to the Agent before the process exits.", (Object)this.queue.size());
                if (this.queue.isEmpty()) {
                    LOG.trace("Reporting queue is empty, stopping progress report...");
                    this.progressFuture.cancel(true);
                    scheduler.shutdown();
                }
            }, 0L, 3L, TimeUnit.SECONDS);
        }
    }

    private static class QueueItem {
        private final HttpEntityEnclosingRequestBase request;
        private final Report report;

        HttpEntityEnclosingRequestBase getRequest() {
            return this.request;
        }

        Report getReport() {
            return this.report;
        }

        QueueItem(HttpEntityEnclosingRequestBase request, Report report) {
            this.request = request;
            this.report = report;
        }
    }
}

