/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.helpers;

import io.testproject.sdk.internal.helpers.RedactHelper;
import io.testproject.sdk.internal.helpers.StashedCommand;
import io.testproject.sdk.internal.helpers.StashedCommands;
import io.testproject.sdk.internal.reporting.inferrers.InferrerFactory;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.messages.TestReport;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.support.ui.FluentWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReportingCommandsExecutor {
    public static final Logger LOG = LoggerFactory.getLogger(ReportingCommandsExecutor.class);
    public static final String STATE_SUCCESS = "success";

    public Response execute(Command var1, boolean var2);

    public AgentClient getAgentClient();

    public StashedCommands getStashedCommands();

    public boolean isReportsDisabled();

    public void setReportsDisabled(boolean var1);

    public boolean isCommandReportsDisabled();

    public void setCommandReportsDisabled(boolean var1);

    public boolean isTestAutoReportsDisabled();

    public void setTestAutoReportsDisabled(boolean var1);

    public boolean isRedactionDisabled();

    public void setRedactionDisabled(boolean var1);

    public AtomicReference<String> getCurrentTest();

    default public void reportCommand(Command command, Response response) {
        boolean isQuitCommand = command.getName().equals("quit");
        List<StackTraceElement> traces = Arrays.asList(Thread.currentThread().getStackTrace());
        if (!this.isTestAutoReportsDisabled()) {
            this.reportTest(traces, isQuitCommand);
        }
        if (isQuitCommand) {
            this.getAgentClient().close();
            return;
        }
        boolean isFluentWait = traces.stream().anyMatch(t -> t.getClassName().equals(FluentWait.class.getName()));
        if (isFluentWait) {
            this.getStashedCommands().add(new StashedCommand(command, response));
        } else {
            this.clearStash();
            if (!this.reportCommand(this.getAgentClient(), command, response, this)) {
                LOG.error("Failed reporting command: {}", (Object)command);
            }
        }
    }

    default public void reportTest(List<StackTraceElement> traces, boolean force) {
        String testName = this.inferTestName(traces);
        if (this.getCurrentTest().get() == null) {
            this.getCurrentTest().set(testName);
        }
        if (testName != null && !testName.equals(this.getCurrentTest().get()) || force) {
            if (this.isReportsDisabled()) {
                LOG.trace("Test [{}] - [Passed]", (Object)this.getCurrentTest().get());
                return;
            }
            if (!this.getAgentClient().reportTest(new TestReport(this.getCurrentTest().get(), true, null))) {
                LOG.error("Failed reporting test [{}] to the Agent", (Object)this.getCurrentTest().get());
            }
            this.getCurrentTest().set(testName);
        }
    }

    default public String inferTestName(List<StackTraceElement> traces) {
        return InferrerFactory.getInferrer(traces).inferTestName();
    }

    default public boolean reportCommand(AgentClient agentClient, Command command, Response response, ReportingCommandsExecutor executor) {
        boolean passed = this.isCommandPassed(response);
        if (executor.isReportsDisabled() || executor.isCommandReportsDisabled()) {
            LOG.trace("Command [{}] - [{}]", (Object)command.getName(), (Object)(passed ? "Passed" : "Failed"));
            return true;
        }
        String screenshot = null;
        if (!passed) {
            try {
                Command screenshotCommand = new Command(command.getSessionId(), "screenshot");
                screenshot = this.execute(screenshotCommand, true).getValue().toString();
            }
            catch (WebDriverException e) {
                LOG.error("Failed to take a screenshot for failed command: {}", (Object)command.getName(), (Object)e);
            }
        }
        return agentClient.reportCommand(this.isRedactionDisabled() ? command : RedactHelper.redactCommand(executor, command), this.extractResponse(response), passed, screenshot);
    }

    private boolean isCommandPassed(Response response) {
        return response.getState().equalsIgnoreCase(STATE_SUCCESS) || response.getStatus() != null && response.getStatus() == 0;
    }

    default public Object extractResponse(Response response) {
        if (response.getValue() != null && Exception.class.isAssignableFrom(response.getValue().getClass())) {
            return ((Exception)response.getValue()).getMessage();
        }
        return response.getValue();
    }

    default public void clearStash() {
        for (StashedCommand stash : this.getStashedCommands().list()) {
            if (this.reportCommand(this.getAgentClient(), stash.getCommand(), stash.getResponse(), this)) continue;
            LOG.error("Failed reporting stashed command: {}", (Object)stash.getCommand());
        }
        this.getStashedCommands().clear();
    }
}

