/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.extensions.junit4;

import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.messages.StepReport;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionsReporter
extends RunListener {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionsReporter.class);

    public void testFailure(Failure failure) {
        AgentClient reportingClient = AgentClient.getInstance();
        if (reportingClient == null) {
            LOG.error("No reporting client available, please make sure you have a TestProject driver initialized");
            return;
        }
        if (!(failure.getException() instanceof AssertionError)) {
            return;
        }
        String resultDescription = failure.getException().getMessage();
        if (resultDescription.isEmpty()) {
            return;
        }
        if (reportingClient.getReportsDisabled()) {
            LOG.trace("Step [{}] - [{}]", (Object)resultDescription, (Object)false);
            return;
        }
        StepReport report = new StepReport(resultDescription, null, false, null);
        if (!reportingClient.reportStep(report)) {
            LOG.error("Failed reporting exception: [{}]", (Object)report);
        }
    }
}

