/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.remote.CommandExecutor;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class FirefoxDriver
extends org.openqa.selenium.firefox.FirefoxDriver
implements ReportingDriver {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public FirefoxDriver() throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, new FirefoxOptions());
    }

    public FirefoxDriver(ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, new FirefoxOptions(), reportType);
    }

    public FirefoxDriver(FirefoxOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options);
    }

    public FirefoxDriver(FirefoxOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, reportType);
    }

    public FirefoxDriver(FirefoxOptions options, boolean disableReports) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(FirefoxOptions options, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports, reportType);
    }

    public FirefoxDriver(FirefoxOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(FirefoxOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false, reportType);
    }

    public FirefoxDriver(FirefoxOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(FirefoxOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false, reportType);
    }

    public FirefoxDriver(String token, FirefoxOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(String token, FirefoxOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, null, null, false, reportType);
    }

    public FirefoxDriver(String token, FirefoxOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(String token, FirefoxOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false, reportType);
    }

    public FirefoxDriver(String token, FirefoxOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(String token, FirefoxOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, FirefoxOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(URL remoteAddress, FirefoxOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, FirefoxOptions options, String projectName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(URL remoteAddress, FirefoxOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, FirefoxOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(URL remoteAddress, FirefoxOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, String token, FirefoxOptions options) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, ReportType.CLOUD_AND_LOCAL);
    }

    public FirefoxDriver(URL remoteAddress, String token, FirefoxOptions options, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, String token, FirefoxOptions options, String projectName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, null, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, String token, FirefoxOptions options, String projectName, String jobName, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, false, reportType);
    }

    public FirefoxDriver(URL remoteAddress, String token, FirefoxOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        this(remoteAddress, token, options, projectName, jobName, disableReports, reportType, null, null);
    }

    public FirefoxDriver(URL remoteAddress, String token, FirefoxOptions options, String projectName, String jobName, boolean disableReports, ReportType reportType, String reportName, String reportPath) throws InvalidTokenException, AgentConnectException, IOException, ObsoleteVersionException {
        super((GeckoDriverService)new FakeDriverService(), new FirefoxOptions().merge(AgentClient.getClient(remoteAddress, token, (Capabilities)options, new ReportSettings(projectName, jobName, reportType, reportName, reportPath), disableReports).getSession().getCapabilities()));
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }

    static class FakeDriverService
    extends GeckoDriverService {
        FakeDriverService() throws IOException {
            super(new File(""), 0, null, null);
        }
    }
}

