/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk;

import io.testproject.sdk.drivers.ReportType;
import io.testproject.sdk.drivers.ReportingDriver;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DriverBuilder<T extends ReportingDriver> {
    private static final Logger LOG = LoggerFactory.getLogger(DriverBuilder.class);
    private Capabilities builderCapabilities;
    private String builderToken;
    private URL builderRemoteAddress;
    private String builderProjectName;
    private String builderJobName;
    private boolean builderDisableReports;
    private ReportType builderReportType;

    public DriverBuilder(Capabilities capabilities) {
        this.builderCapabilities = capabilities;
    }

    public DriverBuilder<T> withCapabilities(Capabilities capabilities) {
        this.builderCapabilities = capabilities;
        return this;
    }

    public DriverBuilder<T> withToken(String token) {
        this.builderToken = token;
        return this;
    }

    public DriverBuilder<T> withRemoteAddress(URL remoteAddress) {
        this.builderRemoteAddress = remoteAddress;
        return this;
    }

    public DriverBuilder<T> withProjectName(String projectName) {
        this.builderProjectName = projectName;
        this.builderDisableReports = false;
        return this;
    }

    public DriverBuilder<T> withJobName(String jobName) {
        this.builderJobName = jobName;
        this.builderDisableReports = false;
        return this;
    }

    public DriverBuilder<T> withReportsDisabled(boolean disableReports) {
        this.builderDisableReports = disableReports;
        if (disableReports) {
            this.builderProjectName = null;
            this.builderJobName = null;
        }
        return this;
    }

    public DriverBuilder<T> withReportType(ReportType reportType) {
        this.builderReportType = reportType;
        return this;
    }

    public T build(Class<T> clazz) {
        Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, (Class[])new Class[]{URL.class, String.class, this.builderCapabilities.getClass(), String.class, String.class, Boolean.TYPE, ReportType.class});
        if (constructor == null) {
            LOG.error("{} doesn't have a constructor required by the builder!", (Object)clazz.getName());
            throw new WebDriverException("Failed to create an instance of " + clazz.getName());
        }
        try {
            return (T)((ReportingDriver)constructor.newInstance(new Object[]{this.builderRemoteAddress, this.builderToken, this.builderCapabilities, this.builderProjectName, this.builderJobName, this.builderDisableReports, this.builderReportType}));
        }
        catch (Exception e) {
            throw new WebDriverException("Failed to create an instance of " + clazz.getName(), (Throwable)e);
        }
    }
}

