/*
 * Copyright (c) 2020 TestProject LTD. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.testproject.sdk.drivers;

/**
 * Custom capabilities provided by TestProject.
 */
public final class TestProjectCapabilityType {

    /**
     * Custom capability to specify cloud provider URL for the driver initialization.
     */
    public static final String CLOUD_URL = "cloud:URL";

    /**
     * Private constructor to prevent creating instances of this final class.
     */
    private TestProjectCapabilityType() { }

}
