/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class RemoteWebDriver
extends org.openqa.selenium.remote.RemoteWebDriver
implements ReportingDriver {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public RemoteWebDriver(Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities);
    }

    public RemoteWebDriver(Capabilities capabilities, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, null, null, disableReports);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, null, false);
    }

    public RemoteWebDriver(Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, capabilities, projectName, jobName, false);
    }

    public RemoteWebDriver(String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, null, null, false);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, null, false);
    }

    public RemoteWebDriver(String token, Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, capabilities, projectName, jobName, false);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, null, null, false);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, null, false);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, capabilities, projectName, jobName, false);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, capabilities, null, null, false);
    }

    public RemoteWebDriver(URL remoteAddress, String token, Capabilities capabilities, String projectName, String jobName, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        super(AgentClient.getClient(remoteAddress, token, capabilities, new ReportSettings(projectName, jobName), disableReports).getSession().getCapabilities());
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }
}

