/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.extensions.cucumber;

import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestStepFinished;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.messages.StepReport;
import io.testproject.sdk.internal.rest.messages.TestReport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberReporter
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CucumberReporter.class);

    public CucumberReporter() {
        LOG.info("Initializing Cucumber reporter");
        System.setProperty("TP_DISABLE_AUTO_REPORTS", "true");
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this::reportCucumberStepFinished);
        publisher.registerHandlerFor(TestCaseFinished.class, this::reportCucumberTestFinished);
    }

    private void reportCucumberTestFinished(TestCaseFinished testCaseFinished) {
        if (AgentClient.getInstance() == null) {
            if (AgentClient.isWarned()) {
                LOG.warn("No active AgentClient instance, skipped reporting test");
            }
            return;
        }
        String uri = testCaseFinished.getTestCase().getUri().toString();
        Pattern pattern = Pattern.compile("([^/]+)\\.");
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() > 0 && AgentClient.getInstance().getSkipInferring()) {
            String featureFileName = matcher.group(1);
            AgentClient.getInstance().updateJobName(featureFileName);
        }
        boolean testCasePassed = testCaseFinished.getResult().getStatus().isOk();
        TestReport test = new TestReport(testCaseFinished.getTestCase().getName(), testCasePassed, null);
        if (!AgentClient.getInstance().reportTest(test)) {
            LOG.error("Failed reporting test: [{}]", (Object)test);
        }
    }

    private void reportCucumberStepFinished(TestStepFinished event) {
        if (event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep cucumberStep = (PickleStepTestStep)event.getTestStep();
            this.reportCucumberStep(cucumberStep, event.getResult());
        }
    }

    private void reportCucumberStep(PickleStepTestStep cucumberStep, Result result) {
        if (AgentClient.getInstance() == null) {
            if (AgentClient.isWarned()) {
                LOG.warn("No active AgentClient instance, skipped reporting test step");
            }
            return;
        }
        String keyword = cucumberStep.getStep().getKeyword();
        String stepDescription = String.format("%s %s", keyword, cucumberStep.getStep().getText());
        String stepArguments = this.getCucumberStepArguments(cucumberStep);
        Object stepMessage = "";
        if (StringUtils.isNotBlank((CharSequence)stepArguments)) {
            stepMessage = stepDescription + " using parameters {" + stepArguments + "}";
        }
        boolean stepPassed = false;
        if (result.getStatus() == Status.PASSED) {
            stepPassed = true;
        } else {
            String errorMessage = System.lineSeparator() + result.getError().getMessage();
            stepMessage = String.format("%s %s", stepMessage, errorMessage);
        }
        StepReport report = new StepReport(stepDescription, (String)stepMessage, stepPassed, null);
        if (!AgentClient.getInstance().reportStep(report)) {
            LOG.error("Failed reporting step: [{}]", (Object)report);
        }
    }

    private String getCucumberStepArguments(PickleStepTestStep cucumberStep) {
        return StringUtils.join((Object[])cucumberStep.getDefinitionArgument().stream().map(Argument::getValue).toArray(), (String)",");
    }
}

