/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.ShutdownThreadManager;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.safari.SafariOptions;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class SafariDriver
extends org.openqa.selenium.safari.SafariDriver
implements ReportingDriver {
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public SafariDriver() throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, new SafariOptions());
    }

    public SafariDriver(SafariOptions options) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options);
    }

    public SafariDriver(SafariOptions options, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports);
    }

    public SafariDriver(SafariOptions options, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false);
    }

    public SafariDriver(SafariOptions options, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false);
    }

    public SafariDriver(String token, SafariOptions options) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, null, null, false);
    }

    public SafariDriver(String token, SafariOptions options, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false);
    }

    public SafariDriver(String token, SafariOptions options, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false);
    }

    public SafariDriver(URL remoteAddress, SafariOptions options) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false);
    }

    public SafariDriver(URL remoteAddress, SafariOptions options, String projectName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false);
    }

    public SafariDriver(URL remoteAddress, SafariOptions options, String projectName, String jobName) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false);
    }

    public SafariDriver(URL remoteAddress, String token, SafariOptions options) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false);
    }

    public SafariDriver(URL remoteAddress, String token, SafariOptions options, String projectName, String jobName, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        super(new SafariOptions(AgentClient.getClient(remoteAddress, token, (Capabilities)options, new ReportSettings(projectName, jobName), disableReports).getSession().getCapabilities()));
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        ShutdownThreadManager.getInstance().addDriver(this, this::stop);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        ShutdownThreadManager.getInstance().removeDriver(this);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }
}

