/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.extensions.testng;

import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.rest.messages.StepReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ExceptionsReporter
implements ITestListener {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionsReporter.class);

    public void onTestFailure(ITestResult result) {
        if (!io.testproject.sdk.interfaces.testng.ExceptionsReporter.class.isAssignableFrom(result.getInstance().getClass())) {
            LOG.error("Class is not implementing the ExceptionReporter interface");
            return;
        }
        ReportingDriver driver = ((io.testproject.sdk.interfaces.testng.ExceptionsReporter)result.getInstance()).getDriver();
        if (driver == null) {
            LOG.error("Could not find reporting driver");
            return;
        }
        if (!(result.getThrowable() instanceof AssertionError)) {
            return;
        }
        String resultDescription = result.getThrowable().getMessage();
        if (resultDescription.isEmpty()) {
            return;
        }
        if (driver.getReportingCommandExecutor().isReportsDisabled()) {
            LOG.trace("Step [{}] - [{}]", (Object)resultDescription, (Object)false);
            return;
        }
        StepReport report = new StepReport(resultDescription, null, false, null);
        if (!driver.getReportingCommandExecutor().getAgentClient().reportStep(report)) {
            LOG.error("Failed reporting exception: [{}]", (Object)report);
        }
    }
}

