/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting;

import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.messages.TestReport;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClosableTestReport
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ClosableTestReport.class);
    private final AgentClient agentClient;
    private final TestReport report;
    private final ReportingDriver driver;
    private boolean submitted;

    public ClosableTestReport(AgentClient agentClient, ReportingDriver driver, String name, boolean passed, String message) {
        this.agentClient = agentClient;
        this.driver = driver;
        this.report = new TestReport(name, passed, message);
    }

    public void setResult(boolean passed) {
        this.report.setPassed(passed);
    }

    public void setMessage(String message) {
        this.report.setMessage(message);
    }

    public void submit() {
        this.close();
    }

    @Override
    public void close() {
        if (this.submitted) {
            return;
        }
        this.submitted = true;
        if (this.driver.getReportingCommandExecutor().isReportsDisabled()) {
            LOG.trace("Test [{}] - [{}]", (Object)this.report.getName(), (Object)(this.report.isPassed() ? "Passed" : "Failed"));
            return;
        }
        if (!this.agentClient.reportTest(this.report)) {
            LOG.error("Failed reporting test to Agent");
        }
    }
}

